<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeAbout extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-about';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - About Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'About', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_about',
			[
				'label' => esc_html__( 'About Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'stars_select',
			[
				'label'       => __( 'Stars Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),
					'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),
					'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),
					'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),
					'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),
				],
				'default'   => '5',
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Content', 'bdevs-elementor' ),
				'default'     => __( 'It is Content', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'phone_number',
			[
				'label'       => __( 'Phone Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Phone Number', 'bdevs-elementor' ),
				'default'     => __( 'It is Phone Number', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'image_1',
			[
				'label'   => esc_html__( 'Image 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Image 1', 'bdevs-elementor' ),
			]
		);	

		$this->add_control(
			'image_2',
			[
				'label'   => esc_html__( 'Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Image 2', 'bdevs-elementor' ),
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_image_1',
			[
				'label'   => esc_html__( 'Show Image 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_image_2',
			[
				'label'   => esc_html__( 'Show Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_phone_number',
			[
				'label'   => esc_html__( 'Show Phone Number', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<section class="about section-padding">
			<h2 style="display: none!important;">The Cappa</h2>
			<div class="container">
				<div class="row">
					<div class="col-md-6 mb-30 animate-box" data-animate-effect="fadeInUp">
						<?php if ( $settings['show_star'] ): ?>
						<span>
							<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } ?>
						</span>
						<?php endif; ?>
						<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
						<div class="section-subtitle"><?php echo wp_kses_post($settings['sub_heading']); ?></div>
						<?php endif; ?>
						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
						<div class="section-title"><?php echo wp_kses_post($settings['heading']); ?></div>
						<?php endif; ?>
						<?php if (( '' !== $settings['content'] ) && ( $settings['show_content'] )): ?>
						<?php echo wp_kses_post($settings['content']); ?>
						<?php endif; ?>
						<!-- call -->
						<?php if (( '' !== $settings['phone_number'] ) && ( $settings['show_phone_number'] )): ?>
						<div class="reservations">
							<div class="icon"><span class="flaticon-call"></span></div>
							<div class="text">
								<?php echo wp_kses_post($settings['phone_number']); ?>
							</div>
						</div>
						<?php endif; ?>
					</div>
					<?php if (( '' !== $settings['image_1']['url'] ) && ( $settings['show_image_1'] )): ?>
					<div class="col col-md-3 animate-box" data-animate-effect="fadeInUp">
						<img src="<?php echo wp_kses_post($settings['image_1']['url']); ?>" alt="" class="mt-90 mb-30">
					</div>
					<?php endif; ?>
					<?php if (( '' !== $settings['image_2']['url'] ) && ( $settings['show_image_2'] )): ?>
					<div class="col col-md-3 animate-box" data-animate-effect="fadeInUp">
						<img src="<?php echo wp_kses_post($settings['image_2']['url']); ?>" alt="">
					</div>
					<?php endif; ?>
				</div>
			</div>
		</section>

	<?php
	}

}
