<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeBlog extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-blog';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - Blog Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'Blog', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_blog',
			[
				'label' => esc_html__( 'Blog Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
            'post_number',
            [
                'label'       => __( 'Post Number', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Post Number', 'bdevs-elementor' ),
                'default'     => __( '6', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
                    'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
                ],
                'default'   => 'asc',
            ]
        );
	   	

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<section class="news section-padding bg-black">
		    <div class="container">
		        <div class="row">
		            <div class="col-md-12">
		                <?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
							<div class="section-subtitle"><span><?php echo wp_kses_post($settings['sub_heading']); ?></span></div>
						<?php endif; ?>
						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
							<div class="section-title"><span><?php echo wp_kses_post($settings['heading']); ?></span></div>
						<?php endif; ?>
		            </div>
		        </div>
		        <div class="row">
		            <div class="col-md-12">
		                <div class="owl-carousel owl-theme">
		                	<?php 
		                	$order = $settings['post_order'];
		                	$post_number = $settings['post_number'];
		                	$wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'post',  'orderby' => 'ID', 'order' => $order));

		                	while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
		                		$home_image = get_post_meta(get_the_ID(),'_cmb_home_image', true);
		                		$single_meta = get_post_meta(get_the_ID(),'_cmb_single_meta', true);
		                		?>
			                    <div class="item">
			                        <div class="position-re o-hidden"> <img src="<?php echo wp_get_attachment_url($home_image);?>" alt="">
			                            <div class="date">
			                                <a href="<?php the_permalink();?>"> <span><?php the_time('M'); ?></span> <i><?php the_time('j'); ?></i> </a>
			                            </div>
			                        </div>
			                        <div class="con"> 
			                        	<span class="category"><?php echo esc_attr($single_meta); ?></span>
			                            <h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
			                        </div>
			                    </div>
		                    <?php endwhile; ?>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>

		<?php if (is_admin())
		{ ?>
			<script type="text/javascript">
				$('.news .owl-carousel').owlCarousel({
					loop: true,
					margin: 30,
					mouseDrag: true,
					autoplay: false,
					dots: false,
					nav: true,
					navText: ["<span class='lnr ti-angle-left'></span>","<span class='lnr ti-angle-right'></span>"],
					responsiveClass: true,
					responsive: {
						0: {
							items: 1,
							dots: true,
							nav: false
						},
						600: {
							items: 2,
							dots: true,
							nav: false
						},
						1000: {
							items: 3
						}
					}
				});
			</script>
		<?php }  ?>
		
	<?php
	}

}
