<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeSidebarSlider2 extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-sidebar-slider-2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home Sidebar - Slider 2 Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-sidebar' ];
	}

	public function get_keywords() {
		return [ 'Slider', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__( 'Slider Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'slider_select',
			[
				'label'     => esc_html__( 'Slider Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'Type 1', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Type 2', 'bdevs-elementor' ),
					'3'  => esc_html__( 'Type 3', 'bdevs-elementor' ),
				],
				'default'   => '2',
			]
		);	

		$this->add_control(
			'stars_select',
			[
				'label'     => esc_html__( 'Stars Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),
					'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),
					'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),
					'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),
					'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),
				],
				'default'   => '5',
			]
		);	

		$this->add_control(
			'video_link',
			[
				'label'       => __( 'Video Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Video Link', 'bdevs-elementor' ),
				'default'     => __( 'It is Video Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Title', 'bdevs-elementor' ),
				'default'     => __( 'It is Title', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Subtitle', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Subtitle', 'bdevs-elementor' ),
				'default'     => __( 'It is Subtitle', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => __( 'Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Link', 'bdevs-elementor' ),
				'default'     => __( 'It is Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Button', 'bdevs-elementor' ),
				'default'     => __( 'It is Button', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'booking_link',
			[
				'label'       => __( 'Search Room Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter link to Search Room', 'bdevs-elementor' ),
				'default'     => __( 'It is Booking Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Form Title', 'bdevs-elementor' ),
				'default'     => __( 'Hotel Booking Form', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_video',
			[
				'label'   => esc_html__( 'Show Video', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_booking_form',
			[
				'label'   => esc_html__( 'Show Booking Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_arrow_down',
			[
				'label'   => esc_html__( 'Show Arrow Down', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'no',
			]
		);
		
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if(wp_kses_post($settings['slider_select'])=='1') { ?>

		<header class="header">
			<div class="video-fullscreen-wrap">
				<!-- The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
				<?php if (( '' !== $settings['video_link'] ) && ( $settings['show_video'] )): ?>
				<div class="video-fullscreen-video" data-overlay-dark="5">
					<video playsinline="" autoplay="" loop="" muted="">
					<source src="<?php echo wp_kses_post($settings['video_link']); ?>" type="video/mp4" autoplay="" loop="" muted="">
					</video>
				</div>
				<?php endif; ?>
				<div class="v-middle caption overlay">
					<div class="container">
						<div class="row">
							<div class="col-md-10 offset-md-1"> 
								<?php if ( $settings['show_star'] ): ?>
								<span>
									<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } ?>
								</span>
								<?php endif; ?>
								<?php if ( '' !== $settings['subtitle'] ) : ?>
									<h4><?php echo wp_kses_post($settings['subtitle']); ?></h4>
								<?php endif; ?>
								<?php if ( '' !== $settings['title'] ) : ?>
									<h1><?php echo wp_kses_post($settings['title']); ?></h1>
								<?php endif; ?>
								<?php if ( '' !== $settings['button'] ) : ?>
									<div class="butn-dark"> <a href="<?php echo wp_kses_post($settings['link']); ?>"><span><?php echo wp_kses_post($settings['button']); ?></span></a> </div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- arrow down -->
			<?php if (( $settings['show_arrow_down'] )): ?>
				<div class="arrow bounce text-center">
		            <a href="#" data-scroll-nav="1" class=""> <i class="ti-arrow-down"></i> </a>
		        </div>
			<?php endif; ?>
		</header>

		<?php } elseif(wp_kses_post($settings['slider_select'])=='2') { ?>

			<header class="header">
			<div class="video-fullscreen-wrap">
				<!-- The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
				<?php if (( '' !== $settings['video_link'] ) && ( $settings['show_video'] )): ?>
				<div class="video-fullscreen-video" data-overlay-dark="5">
					<video playsinline="" autoplay="" loop="" muted="">
					<source src="<?php echo wp_kses_post($settings['video_link']); ?>" type="video/mp4" autoplay="" loop="" muted="">
					</video>
				</div>
				<?php endif; ?>
				<div class="v-middle caption overlay">
					<div class="container">
						<div class="row">
							<div class="col-md-10 offset-md-1"> 
								<?php if ( $settings['show_star'] ): ?>
								<span>
									<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } ?>
								</span>
								<?php endif; ?>
								<?php if ( '' !== $settings['subtitle'] ) : ?>
									<h4><?php echo wp_kses_post($settings['subtitle']); ?></h4>
								<?php endif; ?>
								<?php if ( '' !== $settings['title'] ) : ?>
									<h1><?php echo wp_kses_post($settings['title']); ?></h1>
								<?php endif; ?>
								<?php if ( '' !== $settings['button'] ) : ?>
									<div class="butn-dark"> <a href="<?php echo wp_kses_post($settings['link']); ?>"><span><?php echo wp_kses_post($settings['button']); ?></span></a> </div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>

		<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
		<div class="booking-wrapper booking-sidebar">
			<div class="container">
				<div class="booking-inner clearfix">
					<form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                        <div class="col1 c1">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in">
                                </div>
                            </div>
                        </div>
                        <div class="col1 c2">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out">
                                </div>
                            </div>
                        </div>
                        <div class="col2 c3">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="adult_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Adult', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Adults', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Adults', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Adults', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c4">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="children_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c5">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Rooms', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Room', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Rooms', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Rooms', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Rooms', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col3 c6">
                            <button type="submit" class="btn-form1-submit"><?php echo esc_html__( 'Check Now', 'thecappa' )?></button>
                        </div>
                    </form>
				</div>
			</div>
		</div>
		<?php endif; ?>

		<?php } elseif(wp_kses_post($settings['slider_select'])=='3') { ?>

			<header class="header">
			<div class="video-fullscreen-wrap">
				<!-- The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
				<?php if (( '' !== $settings['video_link'] ) && ( $settings['show_video'] )): ?>
				<div class="video-fullscreen-video" data-overlay-dark="5">
					<video playsinline="" autoplay="" loop="" muted="">
					<source src="<?php echo wp_kses_post($settings['video_link']); ?>" type="video/mp4" autoplay="" loop="" muted="">
					</video>
				</div>
				<?php endif; ?>
				<div class="v-middle caption overlay">
					<div class="container">
						<div class="row">
							<div class="col-md-7"> 
                                <div class="v-middle caption textleft">
                                    <?php if ( $settings['show_star'] ): ?>
								<span>
									<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } ?>
								</span>
								<?php endif; ?>
								<?php if ( '' !== $settings['subtitle'] ) : ?>
									<h4><?php echo wp_kses_post($settings['subtitle']); ?></h4>
								<?php endif; ?>
								<?php if ( '' !== $settings['title'] ) : ?>
									<h3><?php echo wp_kses_post($settings['title']); ?></h3>
								<?php endif; ?>
								<?php if ( '' !== $settings['button'] ) : ?>
									<div class="butn-dark"> <a href="<?php echo wp_kses_post($settings['link']); ?>"><span><?php echo wp_kses_post($settings['button']); ?></span></a> </div>
								<?php endif; ?>
                                </div>
                            </div>
                            <!-- Booking From -->
                            <div class="col-md-5">
                            	<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
                                    <div class="booking-box">
                                    	<?php if ( '' !== $settings['form_title'] ) : ?>
                                        <div class="head-box">
                                            <h4><?php echo wp_kses_post($settings['form_title']); ?></h4>
                                        </div>
                                        <?php endif; ?>
                                        <div class="booking-inner clearfix">
                                            <form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="input1_wrapper">
                                                            <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                                            <div class="input1_inner">
                                                                <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="input1_wrapper">
                                                            <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                                            <div class="input1_inner">
                                                                <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="select1_wrapper">
                                                            <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                                            <div class="select1_inner">
                                                            	<select class="select2 select" name="children_count" style="width: 100%">
                                                            		<option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                                            		<option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                                            		<option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                                            		<option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                                            	</select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="select1_wrapper">
                                                            <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                                            <div class="select1_inner">
                                                            	<select class="select2 select" name="children_count" style="width: 100%">
                                                            		<option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                                            		<option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                                            		<option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                                            		<option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                                            	</select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <button type="submit" class="btn-form1-submit mt-15"><?php echo esc_html__( 'Check Now', 'thecappa' )?></button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
						</div>
					</div>
				</div>
			</div>
			<?php if (( $settings['show_arrow_down'] )): ?>
				<div class="arrow bounce text-center">
					<a href="#" data-scroll-nav="1" class=""> <i class="ti-arrow-down"></i> </a>
				</div>
			<?php endif; ?>
    	</header>
    	<?php } ?>
	<?php
	}

}
