<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeSidebarSlider extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-sidebar-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home Sidebar - Slider Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-sidebar' ];
	}

	public function get_keywords() {
		return [ 'Slider', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__( 'Slider Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'booking_link',
			[
				'label'       => __( 'Search Room Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter link to Search Room', 'bdevs-elementor' ),
				'default'     => __( 'It is Booking Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Slider Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
				    [
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Tab Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '', 'bdevs-elementor' ),
					],	
					[
						'name'        => 'stars_select',
						'label'     => esc_html__( 'Stars Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),
							'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),
							'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),
							'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),
							'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),
						],
						'default'   => '5',
					],			
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_link',
						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '#' , 'bdevs-elementor' ),
					],
					[
						'name'       => 'tab_button',
						'label'      => esc_html__( 'Button', 'bdevs-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( '', 'bdevs-elementor' ),
					],
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_booking_form',
			[
				'label'   => esc_html__( 'Show Booking Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<header class="header slider-fade">
			<div class="owl-carousel owl-theme">
				<!-- The opacity on the image is made with "data-overlay-dark="number". You can change it using the numbers 0-9. -->
				<?php foreach ( $settings['tabs'] as $item ) : ?>
					<?php if ( '' !== $item['tab_image']['url'] ) : ?>
						<div class="text-center item bg-img" data-overlay-dark="3" data-background="<?php echo wp_kses_post($item['tab_image']['url']); ?>">
						<?php endif; ?>
						<div class="v-middle caption">
							<div class="container">
								<div class="row">
									<div class="col-md-10 offset-md-1">
										<?php if ( $settings['show_star'] ): ?>
										<span>
											<?php if(wp_kses_post($item['stars_select'])=='1') { ?>
												<i class="star-rating"></i>
											<?php } elseif(wp_kses_post($item['stars_select'])=='2') { ?>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
											<?php } elseif(wp_kses_post($item['stars_select'])=='3') { ?>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
											<?php } elseif(wp_kses_post($item['stars_select'])=='4') { ?>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
											<?php } elseif(wp_kses_post($item['stars_select'])=='5') { ?>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
												<i class="star-rating"></i>
											<?php } ?>
											</span>
										<?php endif; ?>
											<?php if ( '' !== $item['tab_subtitle'] ) : ?>
												<h4><?php echo wp_kses_post($item['tab_subtitle']); ?></h4>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_title'] ) : ?>
												<h1><?php echo wp_kses_post($item['tab_title']); ?></h1>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_button'] ) : ?>
												<div class="butn-light mt-30 mb-30"> <a href="<?php echo wp_kses_post($item['tab_link']); ?>"><span><?php echo wp_kses_post($item['tab_button']); ?></span></a> </div>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
			</div>
		</header>

		<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
		<div class="booking-wrapper booking-sidebar">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<div class="booking-inner clearfix">
							<form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                        <div class="col1 c1">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in">
                                </div>
                            </div>
                        </div>
                        <div class="col1 c2">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out">
                                </div>
                            </div>
                        </div>
                        <div class="col2 c3">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="adult_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Adult', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Adults', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Adults', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Adults', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c4">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="children_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c5">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Rooms', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Room', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Rooms', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Rooms', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Rooms', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col3 c6">
                            <button type="submit" class="btn-form1-submit"><?php echo esc_html__( 'Check Now', 'thecappa' )?></button>
                        </div>
                    </form>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>

		<?php if (is_admin())
  { ?>
<script type="text/javascript">
	var pageSection = $(".bg-img, section");
    pageSection.each(function (indx) {
        if ($(this).attr("data-background")) {
            $(this).css("background-image", "url(" + $(this).data("background") + ")");
        }
    });
    
	var owl = $('.header .owl-carousel');
    
    // Slider owlCarousel - (Inner Page Slider)
    $('.slider .owl-carousel').owlCarousel({
        items: 1,
        loop: true,
        dots: true,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 5000,
        nav: false,
        navText: ['<i class="ti-angle-left" aria-hidden="true"></i>', '<i class="ti-angle-right" aria-hidden="true"></i>'],
        responsiveClass: true,
        responsive: {
            0: {
                dots: true
            },
            600: {
                dots: true
            },
            1000: {
                dots: true
            }
        }
    });
    
    // Slider owlCarousel (Homepage Slider)
    $('.slider-fade .owl-carousel').owlCarousel({
        items: 1,
        loop: true,
        dots: true,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 5000,
        animateOut: 'fadeOut',
        nav: false,
        navText: ['<i class="ti-angle-left" aria-hidden="true"></i>', '<i class="ti-angle-right" aria-hidden="true"></i>'],
        responsiveClass: true,
        responsive: {
            0: {
                dots: false
            },
            600: {
                dots: false
            },
            1000: {
                dots: true
            }
        }
    });
    owl.on('changed.owl.carousel', function (event) {
        var item = event.item.index - 2; // Position of the current item
        $('span').removeClass('animated fadeInUp');
        $('h4').removeClass('animated fadeInUp');
        $('h1').removeClass('animated fadeInUp');
        $('p').removeClass('animated fadeInUp');
        $('.butn-light').removeClass('animated fadeInUp');
        $('.butn-dark').removeClass('animated fadeInUp');
        $('.owl-item').not('.cloned').eq(item).find('span').addClass('animated fadeInUp');
        $('.owl-item').not('.cloned').eq(item).find('h4').addClass('animated fadeInUp');
        $('.owl-item').not('.cloned').eq(item).find('h1').addClass('animated fadeInUp');
        $('.owl-item').not('.cloned').eq(item).find('p').addClass('animated fadeInUp');
        $('.owl-item').not('.cloned').eq(item).find('.butn-light').addClass('animated fadeInUp');
        $('.owl-item').not('.cloned').eq(item).find('.butn-dark').addClass('animated fadeInUp');
    });
</script>
<?php }  ?>

	<?php
	}

}
