<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesComingSoon extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-coming-soon';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages - Coming Soon Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Coming Soon', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_coming',
			[
				'label' => esc_html__( 'Coming Soon Area', 'bdevs-elementor' ),
			]
		);	

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Background Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'contact_title',
			[
				'label'       => __( 'Contact Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Contact Title', 'bdevs-elementor' ),
				'default'     => __( 'It is Contact Title', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'contact_form',
			[
				'label'       => __( 'Contact Form', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Contact Form', 'bdevs-elementor' ),
				'default'     => __( 'It is Contact Form', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Button', 'bdevs-elementor' ),
				'default'     => __( 'It is Button', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'coming_soon_date',
			[
				'label'       => __( 'Coming Soon Date', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Coming Soon Date', 'bdevs-elementor' ),
				'default'     => __( '2023, 11, 6', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_contact_title',
			[
				'label'   => esc_html__( 'Show Contact Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_contact_form',
			[
				'label'   => esc_html__( 'Show Contact Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>
		<section class="comming section-padding" style="background-image: url(<?php echo wp_kses_post($settings['image']['url']); ?>);">
		<?php endif; ?>
			<div class="v-middle">
				<div class="container">
					<div class="row text-center mb-30">
						<div class="col-md-12">
							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
							<h2><?php echo wp_kses_post($settings['heading']); ?></h2>
							<?php endif; ?>
							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
							<h6><?php echo wp_kses_post($settings['sub_heading']); ?></h6>
							<?php endif; ?>
						</div>
					</div>
					<div class="row text-center mb-30">
						<div class="col-6 offset-md-2 col-md-2">
							<div class="item">
								<div class="down">
									<h3 id="days">00</h3>
								</div>
								<div class="item-info">
									<h6 class="mb-0">Days</h6>
								</div>
							</div>
						</div>
						<div class="col-6 col-md-2">
							<div class="item">
								<div class="down">
									<h3 id="hours">00</h3>
								</div>
								<div class="item-info">
									<h6 class="mb-0">Hours</h6>
								</div>
							</div>
						</div>
						<div class="col-6 col-md-2">
							<div class="item">
								<div class="down">
									<h3 id="minutes">00</h3>
								</div>
								<div class="item-info">
									<h6 class="mb-0">Minutes</h6>
								</div>
							</div>
						</div>
						<div class="col-6 col-md-2">
							<div class="item">
								<div class="down">
									<h3 id="seconds">00</h3>
								</div>
								<div class="item-info">
									<h6 class="mb-0">Seconds</h6>
								</div>
							</div>
						</div>
					</div>
					<div class="row text-center">
						<div class="offset-md-3 col-md-6">
							<?php if (( '' !== $settings['contact_title'] ) && ( $settings['show_contact_title'] )): ?>
							<p><?php echo do_shortcode(wp_kses_post($settings['contact_title'])); ?></p>
							<?php endif; ?>
							<?php if (( '' !== $settings['contact_form'] ) && ( $settings['show_contact_form'] )): ?>
							<?php echo do_shortcode(wp_kses_post($settings['contact_form'])); ?>
							<?php endif; ?>
						</div>
					</div>
					<?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )): ?>
					<div class="row text-center">
						<div class="go-back col-md-12">
							<a href='<?php echo esc_url(home_url('/')); ?>'> <span><i class="ti-arrow-left" aria-hidden="true"></i></span>&nbsp; <?php echo do_shortcode(wp_kses_post($settings['button'])); ?> </a>
						</div>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</section>
		<script type="text/javascript">
			function countdown() {
				var now = new Date();
				var eventDate = new Date(<?php echo do_shortcode(wp_kses_post($settings['coming_soon_date'])); ?>);
				var currentTiime = now.getTime();
				var eventTime = eventDate.getTime();
				var remTime = eventTime - currentTiime;
				var s = Math.floor(remTime / 1000);
				var m = Math.floor(s / 60);
				var h = Math.floor(m / 60);
				var d = Math.floor(h / 24);
				h %= 24;
				m %= 60;
				s %= 60;
				h = (h < 10) ? "0" + h : h;
				m = (m < 10) ? "0" + m : m;
				s = (s < 10) ? "0" + s : s;
				document.getElementById("days").textContent = d;
				document.getElementById("days").innerText = d;
				document.getElementById("hours").textContent = h;
				document.getElementById("minutes").textContent = m;
				document.getElementById("seconds").textContent = s;
				setTimeout(countdown, 1000);
			}
			countdown();
		</script>
	<?php
	}

}
