<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesSpaServices extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-spa-services';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages - Spa Services', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Spa Services', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_services',
			[
				'label' => esc_html__( 'Services Area', 'bdevs-elementor' ),
			]
		);	

		$this->add_control(
			'bg_select',
			[
				'label'     => esc_html__( 'Background Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'White Background', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Black Background', 'bdevs-elementor' ),
				],
				'default'   => '1',
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Services Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
					[
						'name'        => 'services_select',
						'label'     => esc_html__( 'Services Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( 'Left Image', 'bdevs-elementor' ),
							'2'  => esc_html__( 'Right Image', 'bdevs-elementor' ),
						],
						'default'   => '1',
					],		
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '', 'bdevs-elementor' ),
					],			
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_content',
						'label'       => esc_html__( 'Content', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_link',
						'label'       => esc_html__( 'Link', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_time',
						'label'       => esc_html__( 'Time', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<section class="services section-padding2">
			<div class="container">
				<?php $i=0;
				foreach ( $settings['tabs'] as $item ) : 
					$i++;
					?>
					<?php if( wp_kses_post($item['services_select']) == '1'): ?>
						<div class="row">
							<div class="col-md-6 p-0 animate-box" data-animate-effect="fadeInLeft">
								<?php if ( '' !== $item['tab_image']['url'] ) : ?>
									<div class="img left">
										<a href="<?php echo wp_kses_post($item['tab_link']); ?>"><img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt=""></a>
									</div>
								<?php endif; ?>
							</div>
							<?php if( wp_kses_post($settings['bg_select']) == '1'): ?>
							<div class="col-md-6 p-0 bg-cream valign animate-box" data-animate-effect="fadeInRight">
								<?php elseif( wp_kses_post($settings['bg_select']) == '2'): ?>
							<div class="col-md-6 p-0 bg-darkgray valign animate-box" data-animate-effect="fadeInRight">
							<?php endif; ?>
								<div class="content">
									<div class="cont text-left">
										<?php if ( '' !== $item['tab_subtitle'] ) : ?>
											<div class="info">
												<h6><?php echo wp_kses_post($item['tab_subtitle']); ?></h6>
											</div>
										<?php endif; ?>
										<?php if ( '' !== $item['tab_title'] ) : ?>
											<h4><?php echo wp_kses_post($item['tab_title']); ?></h4>
										<?php endif; ?>
										<?php if ( '' !== $item['tab_content'] ) : ?>
											<p><?php echo wp_kses_post($item['tab_content']); ?></p>
										<?php endif; ?>
										<?php if ( '' !== $item['tab_time'] ) : ?>
											<p><span class="flaticon-clock"></span> <?php echo wp_kses_post($item['tab_time']); ?> </p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<?php elseif( wp_kses_post($item['services_select']) == '2'): ?>
							<div class="row">
								<?php if( wp_kses_post($settings['bg_select']) == '1'): ?>
							<div class="col-md-6 p-0 bg-cream order2 valign animate-box" data-animate-effect="fadeInLeft">
								<?php elseif( wp_kses_post($settings['bg_select']) == '2'): ?>
							<div class="col-md-6 p-0 bg-darkgray order2 valign animate-box" data-animate-effect="fadeInLeft">
							<?php endif; ?>
									<div class="content">
										<div class="cont text-left">
											<?php if ( '' !== $item['tab_subtitle'] ) : ?>
												<div class="info">
													<h6><?php echo wp_kses_post($item['tab_subtitle']); ?></h6>
												</div>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_title'] ) : ?>
												<h4><?php echo wp_kses_post($item['tab_title']); ?></h4>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_content'] ) : ?>
												<p><?php echo wp_kses_post($item['tab_content']); ?></p>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_time'] ) : ?>
												<p><span class="flaticon-clock"></span> <?php echo wp_kses_post($item['tab_time']); ?> </p>
											<?php endif; ?>
										</div>
									</div>
								</div>
								<div class="col-md-6 p-0 order1 animate-box" data-animate-effect="fadeInRight">
									<?php if ( '' !== $item['tab_image']['url'] ) : ?>
										<div class="img">
											<a href="<?php echo wp_kses_post($item['tab_link']); ?>"><img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt=""></a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						<?php endif; ?>
					<?php endforeach; ?>
				</div>
			</section>
		

	<?php
	}

}
