<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>

  <?php if ( have_comments() ) : ?>

<div class="col-md-12">
  <h3 class="comments-title"><?php comments_number( esc_html__('0 Comments', 'thecappa'), esc_html__('1 Comment', 'thecappa'), esc_html__('% Comments', 'thecappa')); ?></h3>
  <?php wp_list_comments('callback=thecappa_theme_comment'); ?>
</div>
                               
<?php
        // Are there comments to navigate through?
if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
  ?>
<div class="text-center">
  <ul class="pagination">
    <li>
      <?php //Create pagination links for the comments on the current post, with single arrow heads for previous/next
      paginate_comments_links( array(
        'prev_text' => wp_specialchars_decode( '<i class="ti-arrow-left"></i>',ENT_QUOTES), 
        'next_text' => wp_specialchars_decode( '<i class="ti-arrow-right"></i>',ENT_QUOTES)
      ));  ?>
    </li> 
  </ul>
</div>
<?php endif; // Check for comment navigation ?>
<?php endif; ?>
<?php
    if ( is_singular() ) wp_enqueue_script( "comment-reply" );
        $aria_req = ( $req ? " aria-required='true'" : '' );
        $comment_args = array(
                'id_form' => '',        
                'class_form' => 'row',                         
                'title_reply'=> esc_html__( 'Leave a comment', 'thecappa' ),
                'fields' => apply_filters( 'comment_form_default_fields', array(
                    'author' => '<div class="col-md-6">
                                      <input type="text" placeholder="'.esc_attr__('Full Name *', 'thecappa').'" id="name" name="author" required>
                                  </div>',
                    'email' => '<div class="col-md-6">
                                    <input type="email" placeholder="'.esc_attr__('Email Address *', 'thecappa').'" id="email" name="email" required>
                                </div>'
                ) ),
                'comment_field' => '<div class="col-md-12">
                                        <textarea name="comment" id="message" cols="40" rows="4" placeholder="'.esc_attr__('Write a Comment *', 'thecappa').'"></textarea>
                                    </div>',                    
                 'label_submit' => esc_html__( 'Post a Comment', 'thecappa' ),
                 'class_submit' => 'butn-dark mt-15',
                 'comment_notes_before' => '',
                 'comment_notes_after' => '',               
        )
    ?>
<?php if ( comments_open() ) : ?>
  <div class="col-md-8 mb-30">
      <?php comment_form($comment_args); ?>
  </div>
<?php endif; ?>