<?php
$thecappa_redux_demo = get_option('redux_demo');

//Custom fields:
require_once get_template_directory() . '/framework/class-ocdi-importer.php';
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker_2.php';
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker_3.php';
//Theme Set up:
function thecappa_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
	add_theme_support( 'custom-header' ); 
	add_theme_support( 'custom-background' );
	$lang = get_template_directory_uri() . '/languages';
  load_theme_textdomain('thecappa', $lang);
  remove_filter('the_content', 'wpautop');

  add_theme_support( 'post-thumbnails' );
  // Adds RSS feed links to <head> for posts and comments.
  add_theme_support( 'automatic-feed-links' );
  // Switches default core markup for search form, comment form, and comments
  // to output valid HTML5.
  add_theme_support( 'title-tag' );
  add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    // This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
    'primary' =>  esc_html__( 'Primary Menu: Chosen menu in All Pages except Home 16 to 30', 'thecappa' ),
    'secondary' =>  esc_html__( 'Secondary Menu: Chosen menu in Home 16 to 30', 'thecappa' ),
    'dark' =>  esc_html__( 'Dark Menu: Chosen menu in All Dark pages except Dark Home 16 to 30', 'thecappa' ),
    'dark-2' =>  esc_html__( 'Dark Menu 2: Chosen menu in Dark Home 16 to 30', 'thecappa' ),
    'light-sidebar' =>  esc_html__( 'Light Sidebar Menu: Chosen menu in All light sidebar pages except Home Sidebar 14 to 26', 'thecappa' ),
    'light-sidebar-2' =>  esc_html__( 'Light Sidebar Menu 2: Chosen menu in Home Sidebar 14 to 26', 'thecappa' ),
    'dark-sidebar' =>  esc_html__( 'Dark Sidebar Menu: Chosen menu in All Dark sidebar pages except Dark Home Sidebar 14 to 26', 'thecappa' ),
    'dark-sidebar-2' =>  esc_html__( 'Dark Sidebar Menu 2: Chosen menu in Dark Home Sidebar 14 to 26', 'thecappa' ),
    'toggle' =>  esc_html__( 'Toggle Menu: Chosen menu in All Toggle Pages except Toggle Home 16 to 30', 'thecappa' ),
    'toggle-2' =>  esc_html__( 'Toggle Menu 2: Chosen menu in Toggle Home 16 to 30', 'thecappa' ),
    'dark-toggle' =>  esc_html__( 'Dark Toggle Menu: Chosen menu in All Toggle Dark Pages except Dark Toggle Home 16 to 30', 'thecappa' ),
    'dark-toggle-2' =>  esc_html__( 'Dark Toggle Menu 2: Chosen menu in Dark Toggle Home 16 to 30', 'thecappa' ),
    
	) );
    // This theme uses its own gallery styles.
}
add_action( 'after_setup_theme', 'thecappa_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;

function thecappa_theme_scripts_styles() {
	$thecappa_redux_demo = get_option('redux_demo');
	$protocol = is_ssl() ? 'https' : 'http';
      wp_enqueue_style('googlefonts-1', 'https://fonts.googleapis.com/css2?family=Barlow&family=Barlow+Condensed&family=Gilda+Display&display=swap', array(), null );
      wp_enqueue_style('plugins', get_template_directory_uri().'/assets/css/plugins.css');
      wp_enqueue_style('vegas-slider', get_template_directory_uri().'/assets/css/plugins/vegas.slider.min.css');
      wp_enqueue_style('swiper-bundle', get_template_directory_uri().'/assets/css/swiper-bundle.min.css');
    if(!is_page_template('page-templates/home-2.php') and !is_page_template('page-templates/home-sidebar.php') and !is_page_template('page-templates/home-sidebar-2.php') and !is_page_template('page-templates/dark-sidebar.php') and !is_page_template('page-templates/dark-sidebar-2.php') and !is_page_template('page-templates/home-toggle.php') and !is_page_template('page-templates/home-toggle-2.php') and !is_page_template('page-templates/home-dark.php') and !is_page_template('page-templates/home-dark-2.php') and !is_page_template('page-templates/home-dark-toggle.php') and !is_page_template('page-templates/home-dark-toggle-2.php') and !is_page_template('page-templates/shop-menu-sidebar.php') and !is_page_template('page-templates/shop-dark-menu-sidebar.php') and !is_page_template('page-templates/shop-toggle.php') and !is_page_template('page-templates/sidebar-menu-shop-sidebar.php') and !is_page_template('page-templates/dark-shop-sidebar.php') and !is_page_template('page-templates/toggle-shop-sidebar.php') and !is_singular('product')){
      wp_enqueue_style('thecappa-style', get_template_directory_uri().'/assets/css/style.css');
    }
    if(is_page_template('page-templates/home-2.php')){
      wp_enqueue_style('thecappa-style-2', get_template_directory_uri().'/assets/css/style2.css');
    }
    if(is_page_template('page-templates/home-sidebar.php') or is_page_template('page-templates/shop-menu-sidebar.php') or is_page_template('page-templates/sidebar-menu-shop-sidebar.php')){
      wp_enqueue_style('thecappa-style-3', get_template_directory_uri().'/assets/css/style3.css');
    }
    if(is_page_template('page-templates/home-sidebar-2.php')){
      wp_enqueue_style('thecappa-style-4', get_template_directory_uri().'/assets/css/style4.css');
    }
    if(is_page_template('page-templates/dark-sidebar.php') or is_page_template('page-templates/shop-dark-menu-sidebar.php') or is_page_template('page-templates/dark-shop-sidebar.php')){
      wp_enqueue_style('thecappa-select', get_template_directory_uri().'/assets/css/plugins/select3.css');
      wp_enqueue_style('thecappa-style-5', get_template_directory_uri().'/assets/css/style5.css');
    }
    if(is_page_template('page-templates/dark-sidebar-2.php')){
      wp_enqueue_style('thecappa-select', get_template_directory_uri().'/assets/css/plugins/select3.css');
      wp_enqueue_style('thecappa-style-6', get_template_directory_uri().'/assets/css/style6.css');
    }
    if(is_page_template('page-templates/home-toggle.php') or is_page_template('page-templates/shop-toggle.php') or is_page_template('page-templates/toggle-shop-sidebar.php')){
      wp_enqueue_style('thecappa-style-7', get_template_directory_uri().'/assets/css/style7.css');
    }
    if(is_page_template('page-templates/home-toggle-2.php')){
      wp_enqueue_style('thecappa-style-8', get_template_directory_uri().'/assets/css/style8.css');
    }
    if(is_page_template('page-templates/home-dark.php')){
      wp_enqueue_style('thecappa-style-9', get_template_directory_uri().'/assets/css/style9.css');
    }
    if(is_page_template('page-templates/home-dark-2.php')){
      wp_enqueue_style('thecappa-style-10', get_template_directory_uri().'/assets/css/style10.css');
    }
    if(is_page_template('page-templates/home-dark-toggle.php')){
      wp_enqueue_style('thecappa-style-11', get_template_directory_uri().'/assets/css/style11.css');
    }
    if(is_page_template('page-templates/home-dark-toggle-2.php')){
      wp_enqueue_style('thecappa-style-12', get_template_directory_uri().'/assets/css/style12.css');
    }
      wp_enqueue_style('thecappa-css', get_stylesheet_uri(), array(), '2022-04-25' );
    if(isset($thecappa_redux_demo['chosen-color']) && $thecappa_redux_demo['chosen-color']==1){
      wp_enqueue_style('color', get_template_directory_uri().'/framework/color.php');
    }

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
      wp_enqueue_script('comment-reply' );
      wp_enqueue_script('jquery' );
      wp_enqueue_script('jquery-3.6.3', get_template_directory_uri().'/assets/js/jquery-3.6.3.min.js',array(),false,true);
      wp_enqueue_script('jquery-migrate-3.0.0', get_template_directory_uri().'/assets/js/jquery-migrate-3.0.0.min.js',array(),false,true);
      wp_enqueue_script('modernizr-2.6.2', get_template_directory_uri().'/assets/js/modernizr-2.6.2.min.js',array(),false,true);
      wp_enqueue_script('imagesloaded-pkgd', get_template_directory_uri().'/assets/js/imagesloaded.pkgd.min.js',array(),false,true);
      wp_enqueue_script('jquery-isotope', get_template_directory_uri().'/assets/js/jquery.isotope.v3.0.2.js',array(),false,true);
      wp_enqueue_script('pace', get_template_directory_uri().'/assets/js/pace.js',array(),false,true);
      wp_enqueue_script('popper', get_template_directory_uri().'/assets/js/popper.min.js',array(),false,true);
      wp_enqueue_script('bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js',array(),false,true);
      wp_enqueue_script('scrollIt', get_template_directory_uri().'/assets/js/scrollIt.min.js',array(),false,true);
      wp_enqueue_script('jquery-waypoints', get_template_directory_uri().'/assets/js/jquery.waypoints.min.js',array(),false,true);
      wp_enqueue_script('owl-carousel', get_template_directory_uri().'/assets/js/owl.carousel.min.js',array(),false,true);
      wp_enqueue_script('jquery-stellar', get_template_directory_uri().'/assets/js/jquery.stellar.min.js',array(),false,true);
      wp_enqueue_script('jquery-magnific-popup', get_template_directory_uri().'/assets/js/jquery.magnific-popup.js',array(),false,true);
      wp_enqueue_script('YouTubePopUp', get_template_directory_uri().'/assets/js/YouTubePopUp.js',array(),false,true);
      wp_enqueue_script('select-2', get_template_directory_uri().'/assets/js/select2.js',array(),false,true);
      wp_enqueue_script('datepicker', get_template_directory_uri().'/assets/js/datepicker.js',array(),false,true);
      wp_enqueue_script('smooth-scroll', get_template_directory_uri().'/assets/js/smooth-scroll.min.js',array(),false,true);
      wp_enqueue_script('swiper-bundle', get_template_directory_uri().'/assets/js/swiper-bundle.min.js',array(),false,true);
      wp_enqueue_script('vegas-slider', get_template_directory_uri().'/assets/js/vegas.slider.min.js',array(),false,true);
    if(!is_page_template('page-templates/home-2.php') and !is_page_template('page-templates/home-sidebar.php') and !is_page_template('page-templates/home-sidebar-2.php') and !is_page_template('page-templates/dark-sidebar.php') and !is_page_template('page-templates/dark-sidebar-2.php') and !is_page_template('page-templates/home-toggle.php') and !is_page_template('page-templates/home-toggle-2.php') and !is_page_template('page-templates/home-dark-2.php') and !is_page_template('page-templates/home-dark-toggle.php') and !is_page_template('page-templates/home-dark-toggle-2.php') and !is_page_template('page-templates/shop-menu-sidebar.php') and !is_page_template('page-templates/shop-dark-menu-sidebar.php') and !is_page_template('page-templates/shop-toggle.php') and !is_page_template('page-templates/sidebar-menu-shop-sidebar.php') and !is_page_template('page-templates/dark-shop-sidebar.php') and !is_page_template('page-templates/toggle-shop-sidebar.php') and !is_page_template('page-templates/home-dark.php') and !is_singular('product') and !is_singular('room')){
      wp_enqueue_script('thecappa-custom', get_template_directory_uri().'/assets/js/custom.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-2.php')){
      wp_enqueue_script('thecappa-custom-2', get_template_directory_uri().'/assets/js/custom2.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-sidebar.php') or is_page_template('page-templates/shop-menu-sidebar.php') or is_page_template('page-templates/sidebar-menu-shop-sidebar.php')){
      wp_enqueue_script('thecappa-custom-3', get_template_directory_uri().'/assets/js/custom3.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-sidebar-2.php')){
      wp_enqueue_script('thecappa-custom-4', get_template_directory_uri().'/assets/js/custom4.js',array(),false,true);
    }
    if(is_page_template('page-templates/dark-sidebar.php') or is_page_template('page-templates/shop-dark-menu-sidebar.php') or is_page_template('page-templates/dark-shop-sidebar.php')){
      wp_enqueue_script('thecappa-custom-5', get_template_directory_uri().'/assets/js/custom5.js',array(),false,true);
    }
    if(is_page_template('page-templates/dark-sidebar-2.php')){
      wp_enqueue_script('thecappa-custom-6', get_template_directory_uri().'/assets/js/custom6.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-toggle.php') or is_page_template('page-templates/shop-toggle.php') or is_page_template('page-templates/toggle-shop-sidebar.php')){
      wp_enqueue_script('thecappa-custom-7', get_template_directory_uri().'/assets/js/custom7.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-toggle-2.php')){
      wp_enqueue_script('thecappa-custom-8', get_template_directory_uri().'/assets/js/custom8.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-dark.php')){
      wp_enqueue_script('thecappa-custom-9', get_template_directory_uri().'/assets/js/custom9.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-dark-2.php')){
      wp_enqueue_script('thecappa-custom-10', get_template_directory_uri().'/assets/js/custom10.js',array(),false,true);
    }
    if(is_page_template('page-templates/home-dark-toggle.php')){
      wp_enqueue_script('thecappa-custom-11', get_template_directory_uri().'/assets/js/custom11.js',array(),false,true);
    } 
    if(is_page_template('page-templates/home-dark-toggle-2.php')){
      wp_enqueue_script('thecappa-custom-12', get_template_directory_uri().'/assets/js/custom12.js',array(),false,true);
    }
  }
   
add_action( 'wp_enqueue_scripts', 'thecappa_theme_scripts_styles' );
add_filter('style_loader_tag', 'thecappa_myplugin_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'thecappa_myplugin_remove_type_attr', 10, 2);

function thecappa_myplugin_remove_type_attr($tag, $handle) {
    return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
}

add_filter( 'loop_shop_columns', function() {
    return 2;
}, 20);


function set_custom_woocommerce_pages() {
    if ( class_exists( 'WooCommerce' ) ) {

        $shop_page = get_page_by_title( 'Shop Sidebar' ); 
        if ( $shop_page ) {
            update_option( 'woocommerce_shop_page_id', $shop_page->ID );
        }

        $cart_page = get_page_by_title( 'Cart Page' );
        if ( $cart_page ) {
            update_option( 'woocommerce_cart_page_id', $cart_page->ID );
        }

        $checkout_page = get_page_by_title( 'Checkout Page' ); 
        if ( $checkout_page ) {
            update_option( 'woocommerce_checkout_page_id', $checkout_page->ID );
        }

        $myaccount_page = get_page_by_title( 'My Account Page' ); 
        if ( $myaccount_page ) {
            update_option( 'woocommerce_myaccount_page_id', $myaccount_page->ID );
        }
    }
}
add_action( 'after_setup_theme', 'set_custom_woocommerce_pages' );


function thecappa_custom_wc_ajax_refresh_cart_fragment( $fragments ) {
    ob_start();
    ?>
    <div class="menu-item mini-cart">
        <a href="<?php echo wc_get_cart_url(); ?>" class="cart-contents">
          <span class="cart-icon"></span>
        </a>
        <div class="mini-cart-dropdown">
            <?php woocommerce_mini_cart(); ?>
        </div>
    </div>
    <?php
    $mini_cart = ob_get_clean();
    $fragments['div.menu-item.mini-cart'] = $mini_cart;
    
    unset( $fragments['a.cart-contents'] );
    
    return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'thecappa_custom_wc_ajax_refresh_cart_fragment', 30 );

function thecappa_enqueue_wc_cart_fragments_script() {
    if ( function_exists( 'is_woocommerce' ) ) {
        wp_enqueue_script( 'wc-cart-fragments' );
    }
}
add_action( 'wp_enqueue_scripts', 'thecappa_enqueue_wc_cart_fragments_script' );

add_filter( 'yith_wcwl_locate_template', 'thecappa_custom_yith_wcwl_template_path', 10, 2 );

function thecappa_custom_yith_wcwl_template_path( $located, $template_name ) {
  
    $custom_template = get_stylesheet_directory() . '/yith-woocommerce-wishlist/' . $template_name;

    if ( file_exists( $custom_template ) ) {
        return $custom_template;
    }

    return $located;
}

add_filter('woocommerce_add_to_cart_redirect', 'thecappa_redirect_to_product_page_after_add_to_cart', 10, 1);

function thecappa_redirect_to_product_page_after_add_to_cart($url) {
    if (
        isset($_POST['redirect_to_product']) 
        && $_POST['redirect_to_product'] === '1'
        && isset($_POST['add-to-cart'])
    ) {
        $product_id = absint($_POST['add-to-cart']);
        $product_url = get_permalink($product_id);
        return $product_url;
    }
    return $url;
}

function thecappa_override_mce_options($initArray) {
    $opts = '*[*]';
    $initArray['valid_elements'] = $opts;
    $initArray['extended_valid_elements'] = $opts;
    return $initArray;
} 
add_filter('tiny_mce_before_init', 'thecappa_override_mce_options');

//Custom Excerpt Function
function thecappa_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
}

function thecappa_my_custom_wc_theme_support() {
  add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'thecappa_my_custom_wc_theme_support' );

function thecappa_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}
add_filter( 'comment_form_fields', 'thecappa_move_comment_field_to_bottom');

// Widget Sidebar
function thecappa_widgets_init() {
	register_sidebar( array(
    'name'          => esc_html__( 'Primary Sidebar', 'thecappa' ),
    'id'            => 'sidebar-1',        
		'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'thecappa' ),        
		'before_widget' => '<div id="%1$s" class="widget mb-45 %2$s">',        
		'after_widget'  => '</div>',        
		'before_title'  => '<h6 class="widget-title">',        
		'after_title'   => '</h6>',
    ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Shop Sidebar', 'thecappa' ),
    'id'            => 'sidebar-2',        
    'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'thecappa' ),        
    'before_widget' => '<div id="%1$s" class="single-widget mb-45 %2$s">',        
    'after_widget'  => '</div>',        
    'before_title'  => '<h6 class="widget-title">',        
    'after_title'   => '</h6>',
    ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget 1', 'thecappa' ),
    'id'            => 'footer-widget-1',        
    'description'   => esc_html__( 'Appears in the footer section of the site.', 'thecappa' ),        
    'before_widget' => '',        
    'after_widget'  => '',        
    'before_title'  => '<h3 class="widget-title">',        
    'after_title'   => '</h3>',
    ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget 2', 'thecappa' ),
    'id'            => 'footer-widget-2',        
    'description'   => esc_html__( 'Appears in the footer section of the site.', 'thecappa' ),        
    'before_widget' => '',        
    'after_widget'  => '',        
    'before_title'  => '<h3 class="widget-title">',        
    'after_title'   => '</h3>',
    ) );
  register_sidebar( array(
    'name'          => esc_html__( 'Footer Widget 3', 'thecappa' ),
    'id'            => 'footer-widget-3',        
    'description'   => esc_html__( 'Appears in the footer section of the site.', 'thecappa' ),        
    'before_widget' => '',        
    'after_widget'  => '',        
    'before_title'  => '<h3 class="widget-title">',        
    'after_title'   => '</h3>',
    ) );
}
add_action( 'widgets_init', 'thecappa_widgets_init' );

//function tag widgets
function thecappa_tag_cloud_widget($args) {
	$args['number'] = 0; //adding a 0 will display all tags
	$args['largest'] = 18; //largest tag
	$args['smallest'] = 11; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'thecappa_tag_cloud_widget' );

function thecappa_excerpt() {
  $thecappa_redux_demo = get_option('redux_demo');
  if(isset($thecappa_redux_demo['blog_excerpt'])){
    $limit = $thecappa_redux_demo['blog_excerpt'];
  }else{
    $limit = 80;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

function thecappa_excerpt_2() {
  $thecappa_redux_demo = get_option('redux_demo');
  if(isset($thecappa_redux_demo['room_excerpt'])){
    $limit = $thecappa_redux_demo['room_excerpt'];
  }else{
    $limit = 15;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

//pagination
function thecappa_pagination($pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }
    $pagination = array(
    'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
    'format'    => '',
    'current'     => max( 1, get_query_var('paged') ),
    'total'     => $pages,
    'prev_text' => htmlspecialchars_decode( '<i class="ti-angle-left"></i>'),
    'next_text' => htmlspecialchars_decode( '<i class="ti-angle-right"></i>'),   
    'type'      => 'list',
    'end_size'    => 3,
    'mid_size'    => 3
);
    $return =  paginate_links( $pagination );
  echo str_replace( "<ul class='page-numbers'>", '<ul class="news-pagination-wrap align-center mb-30 mt-30">', $return );
}

function thecappa_search_form( $form ) {
    $form = '
    
    <div class="col-md-12">
        <div class="widget search">
            <form action="' . esc_url(home_url('/')) . '">
                <input type="text" name="s" placeholder="'.esc_attr__('Type here ...', 'thecappa').'">
                <button type="submit"><i class="ti-search" aria-hidden="true"></i></button>
            </form>
        </div>
    </div>
	';
    return $form;
}
add_filter( 'get_search_form', 'thecappa_search_form' );
//Custom comment List:

// Comment Form
function thecappa_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>

  <div class="news-post-comment-wrap">
    <div class="post-user-comment"> <?php echo get_avatar($comment,$size='100' ); ?> </div>
    <div class="post-user-content">
      <h3 class="author-name"><?php printf( get_comment_author_link()) ?><span> <?php comment_time(get_option( 'date_format' )); ?></span></h3>
      <?php comment_text() ?> <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
    </div>
  </div>
     
<?php
}

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'thecappa_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
function thecappa_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
      array(
            'name'      => esc_html__( 'One Click Demo Import', 'thecappa' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Editor', 'thecappa' ),
            'slug'      => 'classic-editor',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Widgets', 'thecappa' ),
            'slug'      => 'classic-widgets',
            'required'  => true,
        ),
      array(
            'name'      => esc_html__( 'Widget Importer & Exporter', 'thecappa' ),
            'slug'      => 'widget-importer-&-exporter',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Contact Form 7', 'thecappa' ),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'WP Maximum Execution Time Exceeded', 'thecappa' ),
            'slug'      => 'wp-maximum-execution-time-exceeded',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Elementor', 'thecappa' ),
            'slug'      => 'elementor',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Woocommerce', 'thecappa' ),
            'slug'      => 'woocommerce',
            'required'  => true,
        ),
      array(
            'name'      => esc_html__( 'YITH WooCommerce Wishlist', 'thecappa' ),
            'slug'      => 'yith-woocommerce-wishlist',
            'required'  => true,
        ), 
      array(
            'name'                     => esc_html__( 'Thecappa Common', 'thecappa' ),
            'slug'                     => 'thecappa-common',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/thecappa-common.zip',
        ),
      array(
            'name'                     => esc_html__( 'Thecappa Elementor', 'thecappa' ),
            'slug'                     => 'thecappa-elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/thecappa-elementor.zip',
        ),
      array(
            'name'                     => esc_html__( 'Custom Product Tabs for WooCommerce', 'thecappa' ),
            'slug'                     => 'yikes-inc-easy-custom-woocommerce-product-tabs',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/yikes-inc-easy-custom-woocommerce-product-tabs.zip',
        ),
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'thecappa' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'thecappa' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'thecappa' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'thecappa' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'thecappa' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'thecappa' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'thecappa' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'thecappa' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'thecappa' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'thecappa' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'thecappa' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}

?>