<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;?>

<?php if(isset($thecappa_redux_demo['shop_banner']['url']) && $thecappa_redux_demo['shop_banner']['url'] != ''){?>
	<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="<?php echo esc_url($thecappa_redux_demo['shop_banner']['url']); ?>">
	<?php }else{?>
		<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="<?php echo get_template_directory_uri();?>/assets/img/slider/5.jpg">
		<?php } ?>
		<div class="container">
			<div class="row">
				<div class="col-md-12 text-left caption mt-90">
					<h5><?php if(isset($thecappa_redux_demo['cart_meta']) && $thecappa_redux_demo['cart_meta'] != ''){?>
						<?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['cart_meta']));?>
					<?php }else{?>
						<?php echo esc_html__( 'Our Cart', 'thecappa' );
					}
					?></h5>
					<h1><?php if(isset($thecappa_redux_demo['cart_title']) && $thecappa_redux_demo['cart_title'] != ''){?>
						<?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['cart_title']));?>
					<?php }else{?>
						<?php echo esc_html__( 'Shop Cart', 'thecappa' );
					}
					?></h1>
			</div>
		</div>
	</div>
</div>

<?php
/*
 * @hooked wc_empty_cart_message - 10
 */
do_action( 'woocommerce_cart_is_empty' );

if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
	<p class="return-to-shop">
		<a class="button wc-backward<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php
				/**
				 * Filter "Return To Shop" text.
				 *
				 * @since 4.6.0
				 * @param string $default_text Default text.
				 */
				echo esc_html( apply_filters( 'woocommerce_return_to_shop_text', __( 'Return to shop', 'woocommerce' ) ) );
			?>
		</a>
	</p>
<?php endif; ?>
