<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeKenburnSlider extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-kenburn-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - Kenburn Slider Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'Kenburn Slider', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__( 'Slider Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'slider_select',
			[
				'label'     => esc_html__( 'Slider Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'Type 1', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Type 2', 'bdevs-elementor' ),
					'3'  => esc_html__( 'Type 3', 'bdevs-elementor' ),
				],
				'default'   => '2',
			]
		);	

		$this->add_control(
			'image_1',
			[
				'label'   => esc_html__( 'Slider Image 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Slider Image 1', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image_2',
			[
				'label'   => esc_html__( 'Slider Image 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Slider Image 2', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image_3',
			[
				'label'   => esc_html__( 'Slider Image 3', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Slider Image 3', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => __( 'Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Link', 'bdevs-elementor' ),
				'default'     => __( 'It is Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Button', 'bdevs-elementor' ),
				'default'     => __( 'It is Button', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'stars_select',
			[
				'label'     => esc_html__( 'Stars Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),
					'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),
					'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),
					'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),
					'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),
				],
				'default'   => '5',
			]
		);

		$this->add_control(
			'phone_number',
			[
				'label'       => __( 'Phone Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Phone Number', 'bdevs-elementor' ),
				'default'     => __( 'It is Phone Number', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'phone_link',
			[
				'label'       => __( 'Phone Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Phone Link', 'bdevs-elementor' ),
				'default'     => __( 'It is Phone Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'booking_link',
			[
				'label'       => __( 'Search Room Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter link to Search Room', 'bdevs-elementor' ),
				'default'     => __( 'It is Booking Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Form Title (Type 3)', 'bdevs-elementor' ),
				'default'     => __( 'Hotel Booking Form', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_phone_number',
			[
				'label'   => esc_html__( 'Show Phone Number', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_booking_form',
			[
				'label'   => esc_html__( 'Show Booking Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if(wp_kses_post($settings['slider_select'])=='1') { ?>
		<aside class="kenburns-section" id="kenburnsSliderContainer" data-overlay-dark="3">
			<div class="kenburns-inner h-100">
				<div class="v-middle caption text-center">
					<div class="container">
						<div class="row h-100">
							<div class="col-md-12"> 
								<?php if ( $settings['show_star'] ): ?>
								<span>
								<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
									<i class="star-rating"></i>
								<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
								<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
								<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
								<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
									<i class="star-rating"></i>
								<?php } ?>
							</span>
								<?php endif; ?>
							<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
							<h4><?php echo wp_kses_post($settings['sub_heading']); ?></h4>
							<?php endif; ?>
							<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
							<h1><?php echo wp_kses_post($settings['heading']); ?></h1>
							<?php endif; ?>
							<?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )): ?>
							<div class="butn-light mt-30 mb-30"> <a href="<?php echo wp_kses_post($settings['link']); ?>"><span><?php echo wp_kses_post($settings['button']); ?></span></a> </div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- reservation -->
		<?php if (( '' !== $settings['phone_number'] ) && ( $settings['show_phone_number'] )): ?>
			<div class="reservation">
				<a href="<?php echo wp_kses_post($settings['phone_link']); ?>">
					<div class="icon d-flex justify-content-center align-items-center">
						<i class="flaticon-call"></i>
					</div>
					<div class="call"><?php echo wp_kses_post($settings['phone_number']); ?></div>
				</a>
			</div>
		<?php endif; ?>
	</aside>
    
    <!-- Booking Search -->
    <?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
		<div class="booking-wrapper">
            <div class="container">
                <div class="booking-inner clearfix">
                    <form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                        <div class="col1 c1">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in">
                                </div>
                            </div>
                        </div>
                        <div class="col1 c2">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out">
                                </div>
                            </div>
                        </div>
                        <div class="col2 c3">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="adult_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Adult', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Adults', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Adults', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Adults', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c4">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="children_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c5">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Rooms', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Room', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Rooms', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Rooms', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Rooms', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col3 c6">
                            <button type="submit" class="btn-form1-submit"><?php echo esc_html__( 'Check Now', 'thecappa' )?></button>
                        </div>
                    </form>
                </div>
            </div>
    	</div>
    	
		<?php endif; ?>

	<?php } elseif(wp_kses_post($settings['slider_select'])=='2') { ?>
		<aside class="kenburns-section" id="kenburnsSliderContainer" data-overlay-dark="3">
	        <div class="kenburns-inner h-100">
	            <div class="v-middle caption text-center">
	                <div class="container">
	                    <div class="row h-100">
	                        <div class="col-md-12"> 
	                        	<?php if ( $settings['show_star'] ): ?>
									<span>
									<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } ?>
								</span>
									<?php endif; ?>
								<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
								<h4><?php echo wp_kses_post($settings['sub_heading']); ?></h4>
								<?php endif; ?>
								<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
								<h1><?php echo wp_kses_post($settings['heading']); ?></h1>
								<?php endif; ?>
								<?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )): ?>
								<div class="butn-light mt-30 mb-30"> <a href="<?php echo wp_kses_post($settings['link']); ?>"><span><?php echo wp_kses_post($settings['button']); ?></span></a> </div>
								<?php endif; ?>
	                        </div>
	                    </div>
	                </div>
	            </div>
	        </div>
	        <!-- reservation -->
	        <?php if (( '' !== $settings['phone_number'] ) && ( $settings['show_phone_number'] )): ?>
				<div class="reservation">
					<a href="<?php echo wp_kses_post($settings['phone_link']); ?>">
						<div class="icon d-flex justify-content-center align-items-center">
							<i class="flaticon-call"></i>
						</div>
						<div class="call"><?php echo wp_kses_post($settings['phone_number']); ?></div>
					</a>
				</div>
			<?php endif; ?>
	        <!-- arrow down -->
	        <div class="arrow bounce text-center">
	            <a href="#" data-scroll-nav="1" class=""> <i class="ti-arrow-down"></i> </a>
	        </div>
	    </aside>
	<?php } elseif(wp_kses_post($settings['slider_select'])=='3') { ?>
		<aside class="kenburns-section" id="kenburnsSliderContainer" data-overlay-dark="3">
			<div class="kenburns-inner h-100">
				<div class="v-middle">
					<div class="container">
						<div class="row h-100">
							<div class="col-md-7"> 
								<div class="v-middle caption textleft">
									<?php if ( $settings['show_star'] ): ?>
									<span>
									<?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
										<i class="star-rating"></i>
									<?php } ?>
								</span>
									<?php endif; ?>
								<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
								<h4><?php echo wp_kses_post($settings['sub_heading']); ?></h4>
								<?php endif; ?>
								<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
								<h3><?php echo wp_kses_post($settings['heading']); ?></h3>
								<?php endif; ?>
								<?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )): ?>
								<div class="butn-light mt-30 mb-30"> <a href="<?php echo wp_kses_post($settings['link']); ?>"><span><?php echo wp_kses_post($settings['button']); ?></span></a> </div>
								<?php endif; ?>
								</div>
							</div>
							<!-- Booking From -->
							<div class="col-md-5">
                            	<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
                                    <div class="booking-box">
                                    	<?php if ( '' !== $settings['form_title'] ) : ?>
                                        <div class="head-box">
                                            <h4><?php echo wp_kses_post($settings['form_title']); ?></h4>
                                        </div>
                                        <?php endif; ?>
                                        <div class="booking-inner clearfix">
                                            <form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="input1_wrapper">
                                                            <label>Check in</label>
                                                            <div class="input1_inner">
                                                                <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="input1_wrapper">
                                                            <label>Check out</label>
                                                            <div class="input1_inner">
                                                                <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="select1_wrapper">
                                                            <label>Adults</label>
                                                            <div class="select1_inner">
                                                                <select class="select2 select" name="adult_count" style="width: 100%">
                                                                    <option value="0">Adults</option>
                                                                    <option value="1">1</option>
                                                                    <option value="2">2</option>
                                                                    <option value="3">3</option>
                                                                    <option value="4">4</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="select1_wrapper">
                                                            <label>Children</label>
                                                            <div class="select1_inner">
                                                                <select class="select2 select" name="children_count" style="width: 100%">
                                                                    <option value="0">Children</option>
                                                                    <option value="1">1</option>
                                                                    <option value="2">2</option>
                                                                    <option value="3">3</option>
                                                                    <option value="4">4</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <button type="submit" class="btn-form1-submit mt-15">Check Availability</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
					</div>
				</div>
			</div>
		</div>
        <!-- arrow down -->
        <div class="arrow bounce text-center">
            <a href="#" data-scroll-nav="1" class=""> <i class="ti-arrow-down"></i> </a>
        </div>
    </aside>
    <?php } ?>

    <script type="text/javascript">jQuery(document).ready(function() {
    	jQuery('#kenburnsSliderContainer').vegas({
    		slides: [{
    			src: "<?php echo wp_kses_post($settings['image_1']['url']); ?>"
    		}, {
    			src: "<?php echo wp_kses_post($settings['image_2']['url']); ?>"
    		}, {
    			src: "<?php echo wp_kses_post($settings['image_3']['url']); ?>"
    		}],
    		overlay: true,
    		transition: 'fade2',
    		animation: 'kenburnsUpRight',
    		transitionDuration: 1000,
    		delay: 10000,
    		animationDuration: 20000
    	});
    });</script>


	<?php
	}

}
