<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesRestaurantMenu extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-restaurant-menu';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages - Restaurant Menu', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Restaurant Menu', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_menu',
			[
				'label' => esc_html__( 'Menu Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Sub Heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Menu Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
					[
						'name'        => 'menu_select',
						'label'     => esc_html__( 'Menu Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( 'active', 'bdevs-elementor' ),
							'2'  => esc_html__( 'inactive', 'bdevs-elementor' ),
						],
						'default'   => '2',
					],		
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
				],
			]
		);

		$this->add_control(
			'tabs_2',
			[
				'label' => esc_html__( 'List Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'list_select',
						'label'     => esc_html__( 'List Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( 'active', 'bdevs-elementor' ),
							'2'  => esc_html__( 'inactive', 'bdevs-elementor' ),
						],
						'default'   => '2',
					],			
					[
						'name'        => 'tab_left_content',
						'label'       => esc_html__( 'Left Content', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
					[
						'name'        => 'tab_right_content',
						'label'       => esc_html__( 'Right Content', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<section id="menu" class="restaurant-menu menu section-padding bg-black">
			<div class="container">
				<div class="row">
					<div class="col-md-12 text-center">
						<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
						<div class="section-subtitle"><span><?php echo wp_kses_post($settings['sub_heading']); ?></span></div>
					<?php endif; ?>
					<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
					<div class="section-title"><span><?php echo wp_kses_post($settings['heading']); ?></span></div>
				<?php endif; ?>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="tabs-icon col-md-10 offset-md-1 text-center">
						<div class="owl-carousel owl-theme">
							<?php $i=0;
							foreach ( $settings['tabs'] as $item ) : 
								$i++;
								?>
								<?php if( wp_kses_post($item['menu_select']) == '1'): ?>
									<div id="tab-<?php echo esc_attr($i); ?>" class="active item">
										<?php if ( '' !== $item['tab_title'] ) : ?>
											<h6><?php echo wp_kses_post($item['tab_title']); ?></h6>
										<?php endif; ?>
									</div>
									<?php elseif( wp_kses_post($item['menu_select']) == '2'): ?>
										<div id="tab-<?php echo esc_attr($i); ?>" class="item">
											<?php if ( '' !== $item['tab_title'] ) : ?>
												<h6><?php echo wp_kses_post($item['tab_title']); ?></h6>
											<?php endif; ?>
										</div>
									<?php endif; ?>
								<?php endforeach; ?>
							</div>
						</div>
						<div class="restaurant-menu-content col-md-12">
							<!-- Starters -->
							<?php $i=0; 
							foreach ( $settings['tabs_2'] as $item ) :
								$i++;
								?>
								<?php if( wp_kses_post($item['list_select']) == '1'): ?>
									<div id="tab-<?php echo esc_attr($i); ?>-content" class="cont active">
										<?php elseif( wp_kses_post($item['list_select']) == '2'): ?>
											<div id="tab-<?php echo esc_attr($i); ?>-content" class="cont">
											<?php endif; ?>
											<div class="row">
												<div class="col-md-5">
													<?php if ( '' !== $item['tab_left_content'] ) : ?>
														<?php echo wp_kses_post($item['tab_left_content']); ?>
													<?php endif; ?>
												</div>
												<div class="col-md-5 offset-md-2">
													<?php if ( '' !== $item['tab_right_content'] ) : ?>
														<?php echo wp_kses_post($item['tab_right_content']); ?>
													<?php endif; ?>
												</div>
											</div>
										</div>
										<!-- Salads -->
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php if (is_admin())
  { ?>
<script type="text/javascript">

	$('.restaurant-menu .owl-carousel').owlCarousel({
        loop: true,
        margin: 0,
        autoplay: false,
        dots: false,
        nav: true,
        navText: ["<span class='lnr ti-angle-left'></span>","<span class='lnr ti-angle-right'></span>"],
        responsiveClass: true,
        responsive: {
            0: {
                items: 2,
                nav: false
            },
            600: {
                items: 3,
                nav: false
            },
            1000: {
                items: 4
            }
        }
    });
    
    // Restaurant Menu Tabs
    $(".restaurant-menu .tabs-icon").on("click", ".item", function () {
        $(".item").removeClass("active");
        var myID = $(this).attr("id");
        $(".restaurant-menu .cont").hide();
        $("#" + myID + "-content").fadeIn();
    });
    $(".restaurant-menu .tabs-icon").on("click", ".owl-item", function () {
        $(this).addClass("actived").siblings().removeClass("actived");
    });

    
</script>
<?php }  ?>
	<?php
	}

}
