<?php

add_action( 'init', 'register_thecappa_Room' );
function register_thecappa_Room() {
    
    $labels = array( 
        'name' => __( 'Room', 'thecappa' ),
        'singular_name' => __( 'Room', 'thecappa' ),
        'add_new' => __( 'Add New Room', 'thecappa' ),
        'add_new_item' => __( 'Add New Room', 'thecappa' ),
        'edit_item' => __( 'Edit Room', 'thecappa' ),
        'new_item' => __( 'New Room', 'thecappa' ),
        'view_item' => __( 'View Room', 'thecappa' ),
        'search_items' => __( 'Search Room', 'thecappa' ),
        'not_found' => __( 'No Room found', 'thecappa' ),
        'not_found_in_trash' => __( 'No Room found in Trash', 'thecappa' ),
        'parent_item_colon' => __( 'Parent Room:', 'thecappa' ),
        'menu_name' => __( 'Room', 'thecappa' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Room',
        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
        'taxonomies' => array( 'Room', 'type' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-admin-multisite', 
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_style' => 'post'
    );

    register_post_type( 'Room', $args );
}
add_action( 'init', 'create_RoomType_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_RoomType_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

  $labels = array(
    'name' => __( 'Type', 'thecappa' ),
    'singular_name' => __( 'Type', 'thecappa' ),
    'search_items' =>  __( 'Search Type','thecappa' ),
    'all_items' => __( 'All Type','thecappa' ),
    'parent_item' => __( 'Parent Type','thecappa' ),
    'parent_item_colon' => __( 'Parent Type:','thecappa' ),
    'edit_item' => __( 'Edit Type','thecappa' ), 
    'update_item' => __( 'Update Type','thecappa' ),
    'add_new_item' => __( 'Add New Type','thecappa' ),
    'new_item_name' => __( 'New Type Name','thecappa' ),
    'menu_name' => __( 'Type','thecappa' ),
  );     

// Now register the taxonomy

  register_taxonomy('type',array('Room',), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type' ),
  ));


}

