<?php
/**
 * Plugin Name: Meta Box
 * Plugin URI:  https://metabox.io
 * Description: Create custom meta boxes and custom fields in WordPress.
 * Version:     5.3.3
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * License:     GPL2+
 * Text Domain: meta-box
 * Domain Path: /languages/
 *
 * @package Meta Box
 */

if ( defined( 'ABSPATH' ) && ! defined( 'RWMB_VER' ) ) {
    register_activation_hook( __FILE__, 'rwmb_check_php_version' );

    /**
     * Display notice for old PHP version.
     */
    function rwmb_check_php_version() {
        if ( version_compare( phpversion(), '5.3', '<' ) ) {
            die( esc_html__( 'Meta Box requires PHP version 5.3+. Please contact your host to upgrade.', 'meta-box' ) );
        }
    }




    require_once dirname( __FILE__ ) . '/inc/loader.php';
    $rwmb_loader = new RWMB_Loader();
    $rwmb_loader->init();


    add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {

    $prefix = '_cmb_';


  // Open Code

    $meta_boxes[] = array(

        'id'         => 'post_setting',

        'title'      => 'Post Setting',

        'pages'      => array('post'), // Post type

        'context'    => 'normal',

        'priority'   => 'high',

        'show_names' => true, // Show field names on the left

        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox

        'fields' => array(

            array(
                'name' => 'Single Select',
                'desc' => 'Select Single',
                'id'   => $prefix . 'single_select',
                'type'    => 'select',
                'options'   => array(
                    'single'            => 'Single Post',
                    'sidebar_single'    => 'Sidebar Post',
                    'sidebar_dark'      => 'Dark Sidebar Post',
                    'toggle_menu'      => 'Toggle Post',
                    'dark_post'      => 'Dark Post',
                    'dark_toggle'      => 'Dark Toggle',
                ),
                'default' => 'single',
            ),

            array(

                'name' => 'Home Image',

                'desc' => 'Input Home Image',

                'id'   => $prefix . 'home_image',

                'type'    => 'image',

            ),

            array(

                'name' => 'Single Meta',

                'desc' => 'Input Single Meta',

                'id'   => $prefix . 'single_meta',

                'type'    => 'text',

            ),

        )

    );

    $meta_boxes[] = array(

        'id'         => 'product_setting',

        'title'      => 'Product Setting',

        'pages'      => array('product'), // Post type

        'context'    => 'normal',

        'priority'   => 'high',

        'show_names' => true, // Show field names on the left

        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox

        'fields' => array(

            array(
                'name' => 'Product Select',
                'desc' => 'Select Product',
                'id'   => $prefix . 'product_select',
                'type'    => 'select',
                'options'   => array(
                    'single'            => 'Light Product',
                    'dark_product'      => 'Dark Product',
                ),
                'default' => 'single',
            ),

        )

    );
		

    $meta_boxes[] = array(

        'id'         => 'room_setting',

        'title'      => 'Room Setting',

        'pages'      => array('room'), // Post type

        'context'    => 'normal',

        'priority'   => 'high',

        'show_names' => true, // Show field names on the left

        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox

        'fields' => array(

            array(

                'name' => 'Room Adult',

                'desc' => 'Input number of adults in the room',

                'id'   => $prefix . 'adult',

                'type'    => 'select',

                'options'   => array(
                    '1'       => '1 Adult',
                    '2'       => '2 Adults',
                    '3'       => '3 Adults',
                    '4'       => '4 Adults',
                ),
                'default' => '1',

            ),

            array(

                'name' => 'Room Children',

                'desc' => 'Input number of children in the room',

                'id'   => $prefix . 'children',

                'type'    => 'select',

                'options'   => array(
                    '1'       => '1 Child',
                    '2'       => '2 Childrens',
                    '3'       => '3 Childrens',
                    '4'       => '4 Childrens',
                ),
                'default' => '1',

            ),

            array(
                'name' => 'Room Select',
                'desc' => 'Select Room',
                'id'   => $prefix . 'room_select',
                'type'    => 'select',
                'options'   => array(
                    'room'            => 'Single Room',
                    'sidebar_room'    => 'Sidebar Room',
                    'sidebar_dark'      => 'Dark Sidebar Room',
                    'toggle_menu'      => 'Toggle Menu Room',
                    'dark_room'      => 'Dark Room',
                    'dark_toggle'      => 'Dark Toggle',
                ),
                'default' => 'room',
            ),

            array(
                'name' => 'Star Rating',
                'desc' => 'Select Star Rating',
                'id'   => $prefix . 'star_rating',
                'type'    => 'select',
                'options'   => array(
                    '1'       => '1 Star',
                    '2'       => '2 Stars',
                    '3'       => '3 Stars',
                    '4'       => '4 Stars',
                    '5'       => '5 Stars',
                ),
                'default' => '5',
            ),

            array(

                'name' => 'Check In Date',

                'desc' => 'Input Check In Date',

                'id'   => $prefix . 'check_in_date',

                'type'    => 'date',

                'js_options' => [
                    'dateFormat'      => 'mm/dd/yy',
                    'showButtonPanel' => true,
                ],

            ),

            array(

                'name' => 'Check Out Date',

                'desc' => 'Input Check Out Date',

                'id'   => $prefix . 'check_out_date',

                'type'    => 'date',

                'js_options' => [
                    'dateFormat'      => 'mm/dd/yy',
                    'showButtonPanel' => true,
                ],

            ),

            array(

                'name' => 'Room Meta',

                'desc' => 'Input Room Meta',

                'id'   => $prefix . 'room_meta',

                'type'    => 'text',

            ),

            array(

                'name' => 'Room Amenities',

                'desc' => 'Input Room Amenities',

                'id'   => $prefix . 'room_amenities',

                'type'    => 'textarea',

            ),

            array(

                'name' => 'Room Price',

                'desc' => 'Input Room Price',

                'id'   => $prefix . 'room_price',

                'type'    => 'text',

            ),

            array(

                'name' => 'Room Image 1',

                'desc' => 'Input Room Image 1',

                'id'   => $prefix . 'room_img_1',

                'type'    => 'image',

            ),

            array(

                'name' => 'Room Image 2',

                'desc' => 'Input Room Image 2',

                'id'   => $prefix . 'room_img_2',

                'type'    => 'image',

            ),

            array(

                'name' => 'Room Facilities 1',

                'desc' => 'Input Room Facilities in Home 1',

                'id'   => $prefix . 'room_facilities_1',

                'type'    => 'textarea',

            ),

            array(

                'name' => 'Room Facilities 2',

                'desc' => 'Input Room Facilities in Home 2',

                'id'   => $prefix . 'room_facilities_2',

                'type'    => 'textarea',

            ),

            array(

                'name' => 'Room Facilities 3',

                'desc' => 'Input Room Facilities in Home 3',

                'id'   => $prefix . 'room_facilities_3',

                'type'    => 'textarea',

            ),

        )

    );



// End Code
    return $meta_boxes;
});
}
