<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Home5Booking extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-5-booking';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home 5 - Booking Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page-5' ];
	}

	public function get_keywords() {
		return [ 'Booking', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_booking',
			[
				'label' => esc_html__( 'Booking Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'bg_select',
			[
				'label'     => esc_html__( 'Background Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'White Background', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Black Background', 'bdevs-elementor' ),
				],
				'default'   => '1',
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'booking_link',
			[
				'label'       => __( 'Search Room Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter link to Search Room', 'bdevs-elementor' ),
				'default'     => __( 'It is Booking Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_booking_form',
			[
				'label'   => esc_html__( 'Show Booking Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if( wp_kses_post($settings['bg_select']) == '1'): ?>
		<section class="section-padding bg-cream">
		<?php elseif( wp_kses_post($settings['bg_select']) == '2'): ?>
		<section class="section-padding bg-black">
		<?php endif; ?> 
			<h2 style="display: none!important;">The Cappa</h2>
			<div class="container">
				<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
					<div class="section-subtitle"><?php echo wp_kses_post($settings['sub_heading']); ?></div>
				<?php endif; ?>
				<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
					<div class="section-title"><?php echo wp_kses_post($settings['heading']); ?></div>
				<?php endif; ?>
				<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
				<div class="booking-inner clearfix">
					<form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                        <div class="col1 c1">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in">
                                </div>
                            </div>
                        </div>
                        <div class="col1 c2">
                            <div class="input1_wrapper">
                                <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                <div class="input1_inner">
                                    <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out">
                                </div>
                            </div>
                        </div>
                        <div class="col2 c3">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="adult_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Adult', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Adults', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Adults', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Adults', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c4">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" name="children_count" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col2 c5">
                            <div class="select1_wrapper">
                                <label><?php echo esc_html__( 'Rooms', 'thecappa' )?></label>
                                <div class="select1_inner">
                                    <select class="select2 select" style="width: 100%">
                                        <option value="1"><?php echo esc_html__( '1 Room', 'thecappa' )?></option>
                                        <option value="2"><?php echo esc_html__( '2 Rooms', 'thecappa' )?></option>
                                        <option value="3"><?php echo esc_html__( '3 Rooms', 'thecappa' )?></option>
                                        <option value="4"><?php echo esc_html__( '4 Rooms', 'thecappa' )?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col3 c6">
                            <button type="submit" class="btn-form1-submit"><?php echo esc_html__( 'Check Now', 'thecappa' )?></button>
                        </div>
                    </form>
				</div>
				<?php endif; ?>
			</div>
		</section>

	<?php
	}

}
