<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomePricing extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-pricing';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - Pricing Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'Pricing', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_pricing',
			[
				'label' => esc_html__( 'Pricing Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'pricing_select',
			[
				'label'     => esc_html__( 'Pricing Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( 'Black Background', 'bdevs-elementor' ),
					'2'  => esc_html__( 'Gray Background', 'bdevs-elementor' ),
				],
				'default'   => '1',
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Content', 'bdevs-elementor' ),
				'default'     => __( 'It is Content', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'phone_number',
			[
				'label'       => __( 'Phone Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Phone Number', 'bdevs-elementor' ),
				'default'     => __( 'It is Phone Number', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Pricing Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [	
				    [
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Tab Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '', 'bdevs-elementor' ),
					],				
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_price',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'       => 'tab_content',
						'label'      => esc_html__( 'Content', 'bdevs-elementor' ),
						'type'       => Controls_Manager::TEXTAREA,
						'dynamic'    => [ 'active' => true ],
						'default'    => esc_html__( '', 'bdevs-elementor' ),
					],
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_phone_number',
			[
				'label'   => esc_html__( 'Show Phone Number', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php if( wp_kses_post($settings['pricing_select']) == '1'): ?>
		<section class="pricing section-padding bg-black">
			<?php elseif( wp_kses_post($settings['pricing_select']) == '2'): ?>
		<section class="pricing section-padding">
			<?php endif; ?> 
			<h2 style="display: none!important;">The Cappa</h2>
			<div class="container">
				<div class="row">
					<div class="col-md-4">
						<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
						<div class="section-subtitle"><span><?php echo wp_kses_post($settings['sub_heading']); ?></span></div>
						<?php endif; ?>
						<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
						<div class="section-title"><span><?php echo wp_kses_post($settings['heading']); ?></span></div>
						<?php endif; ?>
						<?php if (( '' !== $settings['content'] ) && ( $settings['show_content'] )): ?>
						<?php echo wp_kses_post($settings['content']); ?>
						<?php endif; ?>
						<?php if (( '' !== $settings['phone_number'] ) && ( $settings['show_phone_number'] )): ?>
						<div class="reservations mb-30">
							<div class="icon"><span class="flaticon-call"></span></div>
							<div class="text">
								<?php echo wp_kses_post($settings['phone_number']); ?>
							</div>
						</div>
						<?php endif; ?>
					</div>
					<div class="col-md-8">
						<div class="owl-carousel owl-theme">
							<?php foreach ( $settings['tabs'] as $item ) : ?>
								<div class="pricing-card">
									<?php if ( '' !== $item['tab_image']['url'] ) : ?>
									<img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt="">
									<?php endif; ?>
									<div class="desc">
										<?php if ( '' !== $item['tab_title'] ) : ?>
										<div class="name"><?php echo wp_kses_post($item['tab_title']); ?></div>
										<?php endif; ?>
										<?php if ( '' !== $item['tab_price'] ) : ?>
										<div class="amount"><?php echo wp_kses_post($item['tab_price']); ?></div>
										<?php endif; ?>
										<?php if ( '' !== $item['tab_content'] ) : ?>
										<ul class="list-unstyled list">
											<?php echo wp_kses_post($item['tab_content']); ?>
										</ul>
										<?php endif; ?>
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</section>
<?php if (is_admin())
  { ?>
<script type="text/javascript">
	$('.pricing .owl-carousel').owlCarousel({
        loop: true,
        margin: 30,
        mouseDrag: true,
        autoplay: false,
        dots: true,
        autoplayHoverPause: true,
        nav: false,
        navText: ["<span class='lnr ti-angle-left'></span>","<span class='lnr ti-angle-right'></span>"],
        responsiveClass: true,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 1
            },
            1000: {
                items: 2
            }
        }
    });
</script>
<?php }  ?>
	<?php
	}

}
