<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeTestimonials2 extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-testimonials-2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - Testimonials Widget 2', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'Testimonials', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_testimonials',
			[
				'label' => esc_html__( 'Testimonials Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'stars_select',
			[
				'label'       => __( 'Stars Select', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'dynamic' => [ 'active' => true ],
				'options'   => [
					'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),
					'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),
					'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),
					'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),
					'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),
				],
				'default'   => '5',
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Content', 'bdevs-elementor' ),
				'default'     => __( 'It is Content', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'phone_number',
			[
				'label'       => __( 'Phone Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Phone Number', 'bdevs-elementor' ),
				'default'     => __( 'It is Phone Number', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'description',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'It is Description', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'booking_link',
			[
				'label'       => __( 'Search Room Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter link to Search Room', 'bdevs-elementor' ),
				'default'     => __( 'It is Booking Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_phone_number',
			[
				'label'   => esc_html__( 'Show Phone Number', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_description',
			[
				'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_booking_form',
			[
				'label'   => esc_html__( 'Show Booking Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<section class="testimonials">
			<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>
			<div class="background bg-img bg-fixed section-padding pb-0" data-background="<?php echo wp_kses_post($settings['image']['url']); ?>" data-overlay-dark="2">
			<?php endif; ?>
				<div class="container">
					<div class="row">
						<!-- Reservation -->
						<div class="col-md-5 mb-30 mt-30">
							<?php if ( $settings['show_star'] ): ?>
							<p><?php if(wp_kses_post($settings['stars_select'])=='1') { ?>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='2') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='3') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='4') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
							<?php } elseif(wp_kses_post($settings['stars_select'])=='5') { ?>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<i class="star-rating"></i>
								<?php } ?></p>
							<?php endif; ?>
							<?php if (( '' !== $settings['content'] ) && ( $settings['show_content'] )): ?>
							<h5><?php echo wp_kses_post($settings['content']); ?></h5>
							<?php endif; ?>
							<?php if (( '' !== $settings['phone_number'] ) && ( $settings['show_phone_number'] )): ?>
							<div class="reservations mb-30">
								<div class="icon color-1"><span class="flaticon-call"></span></div>
								<div class="text">
									<?php echo wp_kses_post($settings['phone_number']); ?>
								</div>
							</div>
							<?php endif; ?>
							<?php if (( '' !== $settings['description'] ) && ( $settings['show_description'] )): ?>
							<p><i class="ti-check"></i><small><?php echo wp_kses_post($settings['description']); ?></small></p>
							<?php endif; ?>
						</div>
						<!-- Booking From -->
						<div class="col-md-5 offset-md-2">
							<?php if (( '' !== $settings['booking_link'] ) && ( $settings['show_booking_form'] )): ?>
							<div class="booking-box">
								<div class="head-box">
									<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
									<h6><?php echo wp_kses_post($settings['sub_heading']); ?></h6>
									<?php endif; ?>
									<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
									<h4><?php echo wp_kses_post($settings['heading']); ?></h4>
									<?php endif; ?>
								</div>
								
								<div class="booking-inner clearfix">
									<form action="<?php echo wp_kses_post($settings['booking_link']); ?>" method="post" class="form1 clearfix">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="input1_wrapper">
                                                    <label><?php echo esc_html__( 'Check in', 'thecappa' )?></label>
                                                    <div class="input1_inner">
                                                        <input type="text" name="check_in" class="form-control input datepicker" placeholder="Check in">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="input1_wrapper">
                                                    <label><?php echo esc_html__( 'Check out', 'thecappa' )?></label>
                                                    <div class="input1_inner">
                                                        <input type="text" name="check_out" class="form-control input datepicker" placeholder="Check out">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="select1_wrapper">
                                                    <label><?php echo esc_html__( 'Adults', 'thecappa' )?></label>
                                                    <div class="select1_inner">
                                                        <select class="select2 select" name="adult_count" style="width: 100%">
					                                        <option value="1"><?php echo esc_html__( '1 Adult', 'thecappa' )?></option>
					                                        <option value="2"><?php echo esc_html__( '2 Adults', 'thecappa' )?></option>
					                                        <option value="3"><?php echo esc_html__( '3 Adults', 'thecappa' )?></option>
					                                        <option value="4"><?php echo esc_html__( '4 Adults', 'thecappa' )?></option>
					                                    </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="select1_wrapper">
                                                    <label><?php echo esc_html__( 'Children', 'thecappa' )?></label>
                                                    <div class="select1_inner">
                                                    	<select class="select2 select" name="children_count" style="width: 100%">
					                                        <option value="1"><?php echo esc_html__( '1 Children', 'thecappa' )?></option>
					                                        <option value="2"><?php echo esc_html__( '2 Childrens', 'thecappa' )?></option>
					                                        <option value="3"><?php echo esc_html__( '3 Childrens', 'thecappa' )?></option>
					                                        <option value="4"><?php echo esc_html__( '4 Childrens', 'thecappa' )?></option>
					                                    </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn-form1-submit mt-15"><?php echo esc_html__( 'Check Availability', 'thecappa' )?></button>
                                            </div>
                                        </div>
                                    </form>
								</div>
								
							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</section>

		<?php if (is_admin())
		{ ?>
			<script type="text/javascript">
				var pageSection = $(".bg-img, section");
				pageSection.each(function (indx) {
					if ($(this).attr("data-background")) {
						$(this).css("background-image", "url(" + $(this).data("background") + ")");
					}
				});
			</script>
		<?php }  ?>

	<?php
	}

}
