<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class HomeTestimonials extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home-testimonials';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Home - Testimonials Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'home-page' ];
	}

	public function get_keywords() {
		return [ 'Testimonials', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_testimonials',
			[
				'label' => esc_html__( 'Testimonials Area', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add Your Background Image', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Sub Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Testimonials Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_icon',
						'label'   => esc_html__( 'Tab Icon', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '', 'bdevs-elementor' ),
					],		
				    [
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Tab Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						'default'     => esc_html__( '', 'bdevs-elementor' ),
					],	
					[
						'name'        => 'stars_select',
						'label'     => esc_html__( 'Stars Select', 'bdevs-elementor' ),
						'type'      => Controls_Manager::SELECT,
						'dynamic' => [ 'active' => true ],
						'options'   => [
							'1'  => esc_html__( '1 Star', 'bdevs-elementor' ),
							'2'  => esc_html__( '2 Stars', 'bdevs-elementor' ),
							'3'  => esc_html__( '3 Stars', 'bdevs-elementor' ),
							'4'  => esc_html__( '4 Stars', 'bdevs-elementor' ),
							'5'  => esc_html__( '5 Stars', 'bdevs-elementor' ),
						],
						'default'   => '5',
					],			
					[
						'name'        => 'tab_title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'tab_content',
						'label'       => esc_html__( 'Content', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Tab Content' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_star',
			[
				'label'   => esc_html__( 'Show Star', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<section class="testimonials">
			<?php if (( '' !== $settings['image']['url'] ) && ( $settings['show_image'] )): ?>
			<div class="background bg-img bg-fixed section-padding pb-0" data-background="<?php echo wp_kses_post($settings['image']['url']); ?>" data-overlay-dark="3">
			<?php endif; ?>
				<div class="container">
					<div class="row">
						<div class="col-md-8 offset-md-2">
							<div class="testimonials-box">
								<div class="head-box">
									<?php if (( '' !== $settings['sub_heading'] ) && ( $settings['show_sub_heading'] )): ?>
									<h6><?php echo wp_kses_post($settings['sub_heading']); ?></h6>
									<?php endif; ?>
									<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )): ?>
									<h4><?php echo wp_kses_post($settings['heading']); ?></h4>
									<?php endif; ?>
									<div class="line"></div>
								</div>
								<div class="owl-carousel owl-theme">
									<?php foreach ( $settings['tabs'] as $item ) : ?>
										<div class="item">
											<?php if ( '' !== $item['tab_icon']['url'] ) : ?>
												<span class="quote"><img src="<?php echo wp_kses_post($item['tab_icon']['url']); ?>" alt=""></span>
											<?php endif; ?>
											<?php if ( '' !== $item['tab_content'] ) : ?>
												<p><?php echo wp_kses_post($item['tab_content']); ?></p>
											<?php endif; ?>
											<div class="info">
												<?php if ( '' !== $item['tab_image']['url'] ) : ?>
													<div class="author-img"> <img src="<?php echo wp_kses_post($item['tab_image']['url']); ?>" alt=""> </div>
												<?php endif; ?>
												<div class="cont"> 
													<?php if ( $settings['show_star'] ): ?>
													<span>
														<?php if(wp_kses_post($item['stars_select'])=='1') { ?>
															<i class="star-rating"></i>
														<?php } elseif(wp_kses_post($item['stars_select'])=='2') { ?>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
														<?php } elseif(wp_kses_post($item['stars_select'])=='3') { ?>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
														<?php } elseif(wp_kses_post($item['stars_select'])=='4') { ?>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
														<?php } elseif(wp_kses_post($item['stars_select'])=='5') { ?>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
															<i class="star-rating"></i>
														<?php } ?>
													</span>
													<?php endif; ?>
													<?php if ( '' !== $item['tab_title'] ) : ?>
														<h6><?php echo wp_kses_post($item['tab_title']); ?></h6> 
													<?php endif; ?>
													<?php if ( '' !== $item['tab_subtitle'] ) : ?>
														<span><?php echo wp_kses_post($item['tab_subtitle']); ?></span>
													<?php endif; ?>
												</div>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>

		<?php if (is_admin())
		{ ?>
			<script type="text/javascript">
				var pageSection = $(".bg-img, section");
				pageSection.each(function (indx) {
					if ($(this).attr("data-background")) {
						$(this).css("background-image", "url(" + $(this).data("background") + ")");
					}
				});
    
				$('.testimonials .owl-carousel').owlCarousel({
					loop: true,
					margin: 30,
					mouseDrag: true,
					autoplay: false,
					dots: true,
					nav: false,
					navText: ["<span class='lnr ti-angle-left'></span>", "<span class='lnr ti-angle-right'></span>"],
					responsiveClass: true,
					responsive: {
						0: {
							items: 1,
						},
						600: {
							items: 1
						},
						1000: {
							items: 1
						}
					}
				});
			</script>
		<?php }  ?>

	<?php
	}

}
