<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesRecentProduct extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-recent-product';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages - Recent Product Widget', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Recent Product', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_recent_product',
			[
				'label' => esc_html__( 'Recent Product Area', 'bdevs-elementor' ),
			]
		);	

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'Recent Product', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'Our Shop', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'       => __( 'Post Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Post Number', 'bdevs-elementor' ),
				'default'     => __( '6', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'order_by',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'id'  => esc_html__( 'ID', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'date' => esc_html__( 'Date', 'bdevs-elementor' ),
				],
				'default'   => 'date',
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		$order = $settings['post_order'];
		$post_number = $settings['post_number'];
		$order_by = $settings['order_by'];
		?>

		<div class="shop-area rooms1 pt-100 pb-100 shop-elementor recent-shop-area cream-bg">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<?php if ( '' !== $settings['sub_heading'] ) : ?>
						<div class="section-subtitle"><?php echo wp_kses_post($settings['sub_heading']); ?></div>
						<?php endif; ?>
						<?php if ( '' !== $settings['heading'] ) : ?>
						<div class="section-title"><?php echo wp_kses_post($settings['heading']); ?></div>
						<?php endif; ?>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12 col-sm-12">
						<div class="owl-carousel owl-theme">
							<?php
                        $args = array(
                            'posts_per_page' => $post_number,
                            'post_type'      => 'product',
                            'order'          => $order,
                            'orderby'        => $order_by,
                        );

                        $product_query = new \WP_Query($args);

                        while ($product_query->have_posts()) : $product_query->the_post();
                            $product = wc_get_product(get_the_ID());
                            ?>
								<div class="product-item item">
									<div class="position-re o-hidden position-re-order-shop">
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail(); ?>
										</a>
									</div>
									<span class="category">
										<?php echo $product->get_price_html(); ?>
									</span>
									<div class="actions"> 
										<?php $id = $product ? $product->get_id() : get_the_ID();
										echo do_shortcode('[add_to_cart id="' . $id . '"]');?>
										<a class="icon-btn no-scroll" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo esc_attr($id); ?>"><i class="ti-eye"></i></a>
										<div class="wishlist-icon"><?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?></div>
									</div>
									<div class="con">
										<h4 class="shop"><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>
										<div class="line"></div>
									</div>
								</div>
								<?php
							endwhile;
							wp_reset_postdata();
							?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php
		$args = array(
			'posts_per_page' => $post_number,
			'post_type'      => 'product',
			'order'          => $order,
			'orderby'        => $order_by,
		);

		$product_query = new \WP_Query($args);

		while ($product_query->have_posts()) : $product_query->the_post();
			$id = get_the_ID();
			?>
			<div class="grid__quick__view__modal modalarea modal fade" id="exampleModal<?php echo esc_attr($id); ?>" tabindex="-1" aria-labelledby="exampleModal" aria-hidden="true">
				<div class="modal-dialog modal__wraper">
					<div class="modal-content">
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo esc_attr('Close', 'thecappa'); ?>"></button>

						<div class="modal-body">
							<div class="row">
								<div class="col-md-6">
									<?php 
									$product = wc_get_product($id);
									$attachment_ids = $product->get_gallery_attachment_ids();
									?>

									<div class="swiper product-main-slider mb-3">
										<div class="swiper-wrapper">
											<div class="swiper-slide">
												<img src="<?php echo wp_get_attachment_url($product->get_image_id()); ?>" alt="<?php echo esc_attr($product->get_name()); ?>" class="img-fluid">
											</div>

											<?php
											if ($attachment_ids) {
												foreach ($attachment_ids as $attachment_id) {
													$image_url = wp_get_attachment_url($attachment_id);
													echo '<div class="swiper-slide">
													<img src="' . esc_url($image_url) . '" alt="' . esc_attr($product->get_name()) . '" class="img-fluid">
													</div>';
												}
											}
											?>
										</div>
										<div class="swiper-pagination"></div>
										<div class="swiper-button-next"></div>
										<div class="swiper-button-prev"></div>
									</div>

									<?php if ($attachment_ids): ?>
										<div class="swiper product-thumbnail-slider mt-2">
											<div class="swiper-wrapper">
												<div class="swiper-slide">
													<img src="<?php echo wp_get_attachment_url($product->get_image_id()); ?>" alt="<?php echo esc_attr($product->get_name()); ?>" class="img-thumbnail">
												</div>
												<?php
												foreach ($attachment_ids as $attachment_id) {
													$thumbnail_url = wp_get_attachment_image_url($attachment_id, 'thumbnail');
													echo '<div class="swiper-slide">
													<img src="' . esc_url($thumbnail_url) . '" alt="' . esc_attr($product->get_name()) . '" class="img-thumbnail">
													</div>';
												}
												?>
											</div>
										</div>
									<?php endif; ?>
								</div>

								<div class="col-md-6 txt-left">
									<h2 class="product_title"><?php echo esc_html($product->get_name()); ?></h2>
									<div class="price mb-2"><?php echo $product->get_price_html(); ?></div>
									<div class="woocommerce-product-details__short-description"><?php echo wpautop($product->get_short_description()); ?></div>

									<form class="cart" method="post" enctype="multipart/form-data">
										<?php woocommerce_quantity_input(); ?>
										
										<?php wp_nonce_field('woocommerce-add-to-cart', 'woocommerce-add-to-cart-nonce'); ?>
										<input type="hidden" name="redirect_to_product" value="1" />

										<button type="submit" name="add-to-cart" value="<?php echo esc_attr($id); ?>" 
											class="single_add_to_cart_button button alt">
											<?php echo esc_html($product->single_add_to_cart_text()); ?>
										</button>
									</form>
									<div class="product-wishlist mt-3">
										<?php 
										echo do_shortcode('[yith_wcwl_add_to_wishlist product_id="' . esc_attr($id) . '"]'); 
										?>
									</div>
									<div class="product_meta mt-3">
										<?php
										$product_cats = wp_get_post_terms($id, 'product_cat');
										if (!empty($product_cats) && !is_wp_error($product_cats)) {
											echo '<span class="posted_in">' . __('Category:', 'woocommerce') . ' ';
											$cat_links = array();

											foreach ($product_cats as $cat) {
												$cat_links[] = '<a href="' . esc_url(get_term_link($cat->term_id)) . '" rel="tag">' . esc_html($cat->name) . '</a>';
											}

											echo implode(', ', $cat_links);
											echo '</span>';
										}
										?>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

<?php endwhile; ?>


<?php if (is_admin())
  { ?>
<script type="text/javascript">
    $('.rooms1 .owl-carousel').owlCarousel({
        loop: true,
        margin: 30,
        mouseDrag: true,
        autoplay: false,
        dots: true,
        autoplayHoverPause: true,
        nav: false,
        navText: ["<span class='lnr ti-angle-left'></span>","<span class='lnr ti-angle-right'></span>"],
        responsiveClass: true,
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 2
            },
            1000: {
                items: 3
            }
        }
    });
</script>
<?php }  ?>

	<?php
	}

}
