<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class PagesRoomSearch extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'pages-room-search';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pages - Room Search', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'pages' ];
	}

	public function get_keywords() {
		return [ 'Room Search', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_room',
			[
				'label' => esc_html__( 'Room Search Area', 'bdevs-elementor' ),
			]
		);
		
		$this->add_control(
			'booking_button',
			[
				'label'       => __( 'Booking Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Booking Button', 'bdevs-elementor' ),
				'default'     => __( 'Booking', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);	
		
		$this->add_control(
			'detail_button',
			[
				'label'       => __( 'Detail Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Detail Button', 'bdevs-elementor' ),
				'default'     => __( 'Details', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();



		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		); 
		
		$this->add_control(
			'show_booking_button',
			[
				'label'   => esc_html__( 'Show Booking Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		
		$this->add_control(
			'show_detail_button',
			[
				'label'   => esc_html__( 'Show Details Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		?>

		<?php
		$check_in = isset($_POST['check_in']) ? sanitize_text_field($_POST['check_in']) : '';
		$check_out = isset($_POST['check_out']) ? sanitize_text_field($_POST['check_out']) : '';

		if(isset($_POST['adult_count']) && $_POST['adult_count'] != ''){
		    $array1 = array(
		        'key'     => '_cmb_adult',
		        'value'   => $_POST['adult_count'],
		        'compare' => '>=',
		    );
		}else{
		    $array1 = '';
		}

		if(isset($_POST['children_count']) && $_POST['children_count'] != ''){
		    $array2 = array(
		        'key'     => '_cmb_children',
		        'value'   => $_POST['children_count'],
		        'compare' => '>=',
		    );
		}else{
		    $array2 = '';
		}
		
		if(isset($check_in) && $check_in != ''){
		    $array3 = array(
		        'key'     => '_cmb_check_in_date',
		        'value'   => $check_in,
		        'compare' => '<=',
		    );
		}else{
		    $array3 = '';
		}
		
		if(isset($check_out) && $check_out != ''){
		    $array4 = array(
		        'key'     => '_cmb_check_out_date',
		        'value'   => $check_out,
		        'compare' => '>=',
		    );
		}else{
		    $array4 = '';
		}


		$wp_query = new \WP_Query(array(
		    'post_type'      => 'room', 
		    'meta_query'     => array(
	            $array1,
	            $array2,
	            $array3,
				$array4,
		    ),
		));
		?>

		<div class="rooms3 section-padding">
			<div class="container">
				<div class="row">
					<div class="col-md-12">

						<?php
						$the_count = $wp_query->post_count; 
						?>
						<div class="section-title search-results">
							<?php 
							if($the_count == 0){
								echo '0 results'; 
							}elseif($the_count == 1){
								echo '1 result found';
							}else{ 
								echo " $the_count results found";
							} ?>
						</div>
					</div>
				</div>
				<div class="row">
					<?php 
					while ($wp_query -> have_posts()): $wp_query -> the_post(); 
						$room_price = get_post_meta(get_the_ID(),'_cmb_room_price', true);
						$room_facilities_3 = get_post_meta(get_the_ID(),'_cmb_room_facilities_3', true); 
						?>

						<div class="col-md-4">
							<div class="square-flip">
								<div class="square bg-img" data-background="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>">
									<?php if (( '' !== $settings['booking_button'] ) && ( $settings['show_booking_button'] )): ?>
									<span class="category"><a href="<?php the_permalink();?>"><?php echo wp_kses_post($settings['booking_button']); ?></a></span>
								<?php endif; ?>
								<div class="square-container d-flex align-items-end justify-content-end">
									<div class="box-title">
										<h6><?php echo esc_attr($room_price); ?></h6>
										<h4><?php the_title();?></h4>
									</div>
								</div>
								<div class="flip-overlay"></div>
							</div>
							<div class="square2">
								<div class="square-container2">
									<h6><?php echo esc_attr($room_price); ?></h6>
									<h4><?php the_title();?></h4>
									<p><?php if(isset($thecappa_redux_demo['room_excerpt'])){?>
										<?php echo esc_attr(thecappa_excerpt_2($thecappa_redux_demo['room_excerpt'])); ?>
									<?php }else{?>
										<?php echo esc_attr(thecappa_excerpt_2(15)); }?></p>
										<div class="row room-facilities mb-30 facilities-col-2">
											<div class="col-md-12">
												<ul>
													<?php echo htmlspecialchars_decode(esc_attr($room_facilities_3));?>
												</ul>
											</div>
										</div>
										<?php if (( '' !== $settings['detail_button'] ) && ( $settings['show_detail_button'] )): ?>
										<div class="btn-line"><a href="<?php the_permalink();?>"><?php echo wp_kses_post($settings['detail_button']); ?></a></div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		</div>
	</div>
		

	<?php
	}

}
