<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
$thecappa_redux_demo = get_option('redux_demo');
get_header(); ?> 

<?php if(isset($thecappa_redux_demo['404_bg']['url']) && $thecappa_redux_demo['404_bg']['url'] != ''){?>
<section class="comming section-padding" style="background-image: url(<?php echo esc_url($thecappa_redux_demo['404_bg']['url']); ?>);">
    <?php }else{?>
<section class="comming section-padding">
<?php } ?>
    <div class="v-middle">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h1><?php if(isset($thecappa_redux_demo['404_title']) && $thecappa_redux_demo['404_title'] != ''){?>
                        <?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['404_title']));?>
                    <?php }else{?>
                        <?php echo esc_html__( '404', 'thecappa' );
                    }
                    ?></h1>
                    <h2><?php if(isset($thecappa_redux_demo['404_subtitle']) && $thecappa_redux_demo['404_subtitle'] != ''){?>
                        <?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['404_subtitle']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'Not Found 404', 'thecappa' );
                    }
                    ?></h2>
                </div>
            </div>
            <div class="row text-center">
                <div class="col-md-6 offset-md-3 text-center">
                    <p><?php if(isset($thecappa_redux_demo['404_content']) && $thecappa_redux_demo['404_content'] != ''){?>
                        <?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['404_content']));?>
                    <?php }else{?>
                        <?php echo esc_html__( 'The page you are looking for was moved, removed, renamed or never existed.', 'thecappa' );
                    }
                    ?></p>
                    <form action="<?php echo esc_url(home_url('/')); ?>">
                        <input type="text"  name="s" placeholder="<?php echo esc_attr__( 'Search', 'thecappa' )?>" required>
                        <button><?php if(isset($thecappa_redux_demo['404_button']) && $thecappa_redux_demo['404_button'] != ''){?>
                            <?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['404_button']));?>
                        <?php }else{?>
                            <?php echo esc_html__( 'Search', 'thecappa' );
                        }
                        ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer('coming'); ?>