<?php
/*
 * The Template for displaying all posts
 * 
 */
$thecappa_redux_demo = get_option('redux_demo');
get_header(); ?>

<?php if(isset($thecappa_redux_demo['blog_banner']['url']) && $thecappa_redux_demo['blog_banner']['url'] != ''){?>
<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="<?php echo esc_url($thecappa_redux_demo['blog_banner']['url']); ?>">
<?php }else{?>
<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="<?php echo get_template_directory_uri();?>/assets/img/slider/5.jpg">
<?php } ?>
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-left caption mt-90">
                    <h1><?php
                    if ( is_day() ) :
                        printf( esc_html__( 'Daily Archives: %s', 'thecappa' ), get_the_date() );
                    elseif ( is_month() ) :
                        printf( esc_html__( 'Monthly Archives: %s', 'thecappa' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'thecappa' ) ) );
                    elseif ( is_year() ) :
                        printf( esc_html__( 'Yearly Archives: %s', 'thecappa' ), get_the_date( _x( 'Y', 'yearly archives date format', 'thecappa' ) ) );
                    else :
                        echo esc_html__( 'Archives', 'thecappa' );
                    endif;
                    ?></h1>
                </div>
            </div>
        </div>
    </div>
    <!-- News 2 -->
    <section class="news2 section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <div class="row">
                        <?php 
                        while (have_posts()): the_post();
                            ?>
                        <div class="col-md-12">
                            <div class="item">
                                <?php if (has_post_thumbnail()) { ?> 
                                <div class="post-img">
                                    <a href="<?php the_permalink();?>"> <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt=""> </a>
                                </div>
                                <?php } ?>
                                <div class="post-cont"> 
                                    <div class="info">
                                        <?php the_author_posts_link(); ?> / <?php the_time(get_option( 'date_format'));?>
                                    </div>
                                    <h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
                                    <p><?php if(isset($thecappa_redux_demo['blog_excerpt'])){?>
                                        <?php echo esc_attr(thecappa_excerpt($thecappa_redux_demo['blog_excerpt'])); ?>
                                    <?php }else{?>
                                        <?php echo esc_attr(thecappa_excerpt(40)); 
                                    }
                                    ?></p>
                                    <div class="butn-dark"> <a href="<?php the_permalink();?>"><span><?php echo esc_html__( 'Read More', 'thecappa' )?></span></a> </div>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                        <div class="col-md-12">
                            <!-- Pagination -->
                            <?php thecappa_pagination();?>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="news2-sidebar row">
                        <?php get_sidebar();?>
                    </div>
                </div>
            </div>
        </div>
    </section>



<?php
get_footer();
?>