<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<?php $thecappa_redux_demo = get_option('redux_demo'); ?>

<head>

    <!-- Meta Tags -->

    <meta charset="<?php bloginfo( 'charset' ); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {?>

        <?php if(isset($thecappa_redux_demo['favicon']['url'])){?>

            <link rel="shortcut icon" href="<?php echo esc_url($thecappa_redux_demo['favicon']['url']); ?>">

        <?php } ?>

    <?php } ?>

    <?php wp_head(); ?> 


</head>

<body <?php body_class(' dark2'); ?>>

<div class="preloader-bg"></div>
<div id="preloader">
    <div id="preloader-status">
        <div class="preloader-position loader"> <span></span> </div>
    </div>
</div>
<!-- Progress scroll totop -->
<div class="progress-wrap cursor-pointer">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
    </svg>
</div>
<!-- Navbar -->
<nav class="navbar navbar-expand-md">
    <div class="container">
        <!-- Logo -->
        <?php if(isset($thecappa_redux_demo['logo']['url']) && $thecappa_redux_demo['logo']['url'] != ''){?>
            <div class="logo-wrapper navbar-brand valign">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <div class="logo">
                        <img src="<?php echo esc_url($thecappa_redux_demo['logo']['url']); ?>" class="logo-img" alt="">
                    </div>
                </a>
            </div>
        <?php }else{?>
            <div class="logo-wrapper navbar-brand valign">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <div class="logo">
                        <img src="<?php echo get_template_directory_uri();?>/assets/img/logo.png" class="logo-img" alt="">
                    </div>
                </a>
            </div>
        <?php } ?>
        <!-- Button -->
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation"> <span class="icon-bar"><i class="ti-menu"></i></span> </button>
            <!-- Navbar links -->
            <div class="collapse navbar-collapse" id="navbar">
            <?php 
            wp_nav_menu( 
                array( 
                    'theme_location' => 'dark',
                    'container' => '',
                    'menu_class' => '', 
                    'menu_id' => '',
                    'menu'            => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'echo'            => true,
                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                    'walker'            => new thecappa_wp_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul class="navbar-nav ms-auto %2$s">%3$s</ul>',
                    'depth'           => 0,        
                )
            ); ?>
            <?php if(isset($thecappa_redux_demo['cart']) && $thecappa_redux_demo['cart']==1){ ?>
            <div class="menu-item mini-cart">
                <a href="<?php echo wc_get_cart_url(); ?>" class="cart-contents">
                    <span class="cart-icon"></span>
                </a>
                <div class="mini-cart-dropdown">
                    <?php woocommerce_mini_cart(); ?>
                </div>
            </div>
            <?php }?>
        </div>
    </div>
</nav>