<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<?php $thecappa_redux_demo = get_option('redux_demo'); ?>

<head>

    <!-- Meta Tags -->

    <meta charset="<?php bloginfo( 'charset' ); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {?>

        <?php if(isset($thecappa_redux_demo['favicon']['url'])){?>

            <link rel="shortcut icon" href="<?php echo esc_url($thecappa_redux_demo['favicon']['url']); ?>">

        <?php } ?>

    <?php } ?>

    <?php wp_head(); ?> 


</head>

<body <?php body_class(); ?>  data-spy="scroll" data-target=".navbar" data-offset="50">

    <div class="preloader-bg"></div>
    <div id="preloader">
        <div id="preloader-status">
            <div class="preloader-position loader"> <span></span> </div>
        </div>
    </div>
    <!-- Progress scroll totop -->
    <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <a href="#" class="js-cappa-nav-toggle cappa-nav-toggle"><i></i></a>
    
    <aside id="cappa-aside">
        <!-- Logo -->
        <?php if(isset($thecappa_redux_demo['logo']['url']) && $thecappa_redux_demo['logo']['url'] != ''){?>
            <div class="cappa-logo">
                <a href="<?php echo esc_url(home_url('/')); ?>">
					<div> <i class="star"></i> <i class="star"></i> <i class="star"></i> <i class="star"></i> <i class="star"></i> </div>
                    <img src="<?php echo esc_url($thecappa_redux_demo['logo']['url']); ?>" class="logo-img" alt="">
                </a>
            </div>
        <?php }else{?>
            <div class="cappa-logo">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <!-- <img src="img/logo-dark.png" class="logo-img" alt=""> -->
                    <div> <i class="star"></i> <i class="star"></i> <i class="star"></i> <i class="star"></i> <i class="star"></i> </div>
                    <h2><?php echo esc_html__( 'The Cappa', 'thecappa' )?><span><?php echo esc_html__( 'Luxury Hotel', 'thecappa' )?></span></h2>
                </a>
            </div>
        <?php } ?>
        <!-- Menu -->
        <nav class="cappa-main-menu">
            <?php 
                wp_nav_menu( 
                    array( 
                        'theme_location' => 'dark-sidebar-2',
                        'container' => '',
                        'menu_class' => '', 
                        'menu_id' => '',
                        'menu'            => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'echo'            => true,
                        'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                        'walker'            => new thecappa_wp_bootstrap_navwalker_2(),
                        'before'          => '',
                        'after'           => '',
                        'link_before'     => '',
                        'link_after'      => '',
                        'items_wrap'      => '<ul class=" %2$s">%3$s</ul>',
                        'depth'           => 0,        
                    )
                ); ?>
        </nav>
        <!-- Sidebar Footer -->
        <div class="cappa-footer">
            <div class="footer-column footer-contact">
                <div class="footer-contact-info">
                    <div class="reservations">
                        <?php if(isset($thecappa_redux_demo['reservation_icon']) && $thecappa_redux_demo['reservation_icon'] != ''){?>
                        <div class="icon"><span class="<?php echo esc_attr($thecappa_redux_demo['reservation_icon']); ?>"></span></div>
                        <?php }else{?>
                        <div class="icon"><span class="flaticon-call"></span></div>
                        <?php } ?>

                        <?php if(isset($thecappa_redux_demo['reservation_text']) && $thecappa_redux_demo['reservation_text'] != ''){?>
                            <div class="text">
                                <?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['reservation_text']));?>
                            </div>
                        <?php }else{?>
                            <div class="text">
                                <p><?php echo esc_html__( 'Reservation', 'thecappa' )?></p> <a href="tel:855-100-4444"><?php echo esc_html__( '855 100 4444', 'thecappa' )?></a>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </aside>

    <div id="cappa-main">