<?php
/*
 * Template Name: Room Search
 * Description: A Page Template with a Page Builder design.
 */
 $thecappa_redux_demo = get_option('redux_demo');
get_header(); ?>

<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="img/slider/3.jpg">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-right caption mt-90">
                    <span>
                        <i class="star-rating"></i>
                        <i class="star-rating"></i>
                        <i class="star-rating"></i>
                        <i class="star-rating"></i>
                        <i class="star-rating"></i>
                    </span>
                    <h5>The Cappa Luxury Hotel</h5>
                    <h1>Rooms & Suites</h1>
                </div>
            </div>
        </div>
    </div>
    <!-- Rooms 3 -->
    
    <div class="rooms3 section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    
                    <?php
                    if($_POST['adult_count']!= ''){
                        $array1 = array(

                            'key'     => '_cmb_adult',

                            'value'   => $_POST['adult_count'],

                            'compare' => '=',

                        );
                    }else{
                        $array1 = '';
                    }

                    if($_POST['children_count']!= ''){
                        $array2 = array(

                            'key'     => '_cmb_children',

                            'value'   => $_POST['children_count'],

                            'compare' => '=',

                        );
                    }else{
                        $array2 = '';
                    }

                    $args = array(    
                        'post_type' => 'room',
                        'posts_per_page' => 6,
                        'meta_query' => array(

                         $array1,$array2

                     ),
                    );
                    $wp_query = new WP_Query($args);
                    $the_count = $wp_query->post_count; 
                    ?>
                    <div class="section-title">
                        <?php 
                        if($the_count == 0){
                            echo '<div></div>'; 
                        }elseif($the_count == 1){
                            echo '1 result';
                        }else{ 
                            echo " $the_count  results";
                        } ?>
                    </div>
                </div>
            </div>
            <div class="row">
            	

				<?php   
                    if($_POST['adult_count']!= ''){
                        $array1 = array(

                            'key'     => '_cmb_adult',

                            'value'   => $_POST['adult_count'],

                            'compare' => '=',

                        );
                    }else{
                        $array1 = '';
                    }

                    if($_POST['children_count']!= ''){
                        $array2 = array(

                            'key'     => '_cmb_children',

                            'value'   => $_POST['children_count'],

                            'compare' => '=',

                        );
                    }else{
                        $array2 = '';
                    }

                        $args = array(    
                            'paged' => $paged,
                            'post_type' => 'room',
							'posts_per_page' => 6,
                            'meta_query' => array(

                               $array1,$array2

                            ),
                           );
                        $wp_query = new WP_Query($args);
						if ( have_posts() ) :
                        while ($wp_query -> have_posts()): $wp_query -> the_post(); 
						$room_price = get_post_meta(get_the_ID(),'_cmb_room_price', true);
						$room_facilities_3 = get_post_meta(get_the_ID(),'_cmb_room_facilities_3', true); 
                ?>

                <div class="col-md-4">
                    <div class="square-flip">
                        <div class="square bg-img" data-background="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>">
                            <span class="category"><a href="<?php the_permalink();?>">Book</a></span>
                            <div class="square-container d-flex align-items-end justify-content-end">
                                <div class="box-title">
                                    <h6><?php echo esc_attr($room_price); ?></h6>
									<h4><?php the_title();?></h4>
                                </div>
                            </div>
                            <div class="flip-overlay"></div>
                        </div>
                        <div class="square2">
                            <div class="square-container2">
                            	<h6><?php echo esc_attr($room_price); ?></h6>
                            	<h4><?php the_title();?></h4>
                            	<p><?php if(isset($thecappa_redux_demo['room_excerpt'])){?>
                            		<?php echo esc_attr(thecappa_excerpt_2($thecappa_redux_demo['room_excerpt'])); ?>
                            	<?php }else{?>
                            		<?php echo esc_attr(thecappa_excerpt_2(15)); }?></p>
                            		<div class="row room-facilities mb-30 facilities-col-2">
                            			<div class="col-md-12">
                            				<ul>
                            					<?php echo htmlspecialchars_decode(esc_attr($room_facilities_3));?>
                            				</ul>
                            			</div>
                            		</div>
                                <div class="btn-line"><a href="<?php the_permalink();?>">Details</a></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; else :?>
				<div class="result" >
					<h3 class="count">
					<?php
					echo esc_html__( 'No Result', 'thecappa' ) ;?>
					</h3>
				</div>
				<?php endif;?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>