<?php
/*
 * Template Name: Sidebar Menu Shop Sidebar
 * Description: A Page Template with a Page Builder design.
 */
$thecappa_redux_demo = get_option('redux_demo');
get_header('sidebar'); ?>

<?php if(isset($thecappa_redux_demo['shop_banner']['url']) && $thecappa_redux_demo['shop_banner']['url'] != ''){?>
	<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="<?php echo esc_url($thecappa_redux_demo['shop_banner']['url']); ?>">
	<?php }else{?>
		<div class="banner-header section-padding valign bg-img bg-fixed" data-overlay-dark="4" data-background="<?php echo get_template_directory_uri();?>/assets/img/slider/5.jpg">
		<?php } ?>
		<div class="container">
			<div class="row">
				<div class="col-md-12 text-left caption mt-90">
					<h5><?php if(isset($thecappa_redux_demo['shop_meta']) && $thecappa_redux_demo['shop_meta'] != ''){?>
						<?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['shop_meta']));?>
					<?php }else{?>
						<?php echo esc_html__( 'Our Product', 'thecappa' );
					}
					?></h5>
					<h1><?php if(isset($thecappa_redux_demo['shop_title']) && $thecappa_redux_demo['shop_title'] != ''){?>
						<?php echo htmlspecialchars_decode(esc_attr($thecappa_redux_demo['shop_title']));?>
					<?php }else{?>
						<?php echo esc_html__( 'Product', 'thecappa' );
					}
					?></h1>
				</div>
			</div>
		</div>
	</div>

	<div class="shop-area pt-100 pb-100">
		<!-- Product -->
		<div class="container">
			<div class="row">

				<div class="col-md-8 col-sm-8">
					<div class="row">
						<?php $args = array( 
							'post_type' => 'product',
							'posts_per_page' => 9,
						);
						$wp_query = new wp_query($args);
						while ( have_posts() ) : the_post(); 
							?>
							<div class="col-lg-4 col-md-6 product-item">
								<div class="product-wrapper mb-75">
									<div class="product-img mb-25">
										<a href="<?php the_permalink();?>">
											<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="">
										</a>
									</div>
									<div class="product-content">
										<h4 class="shop"><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>
										<div class="product-meta">
											<div class="pro-price">
												<?php echo $product->get_price_html(); ?>
											</div>
										</div>
										<div class="shop-add-to-cart">
											<?php $id = get_the_ID();
											echo do_shortcode( '[add_to_cart id='.$id.']' );?>
										</div>
									</div>
								</div>
							</div>
						<?php endwhile ?>
					</div>
				</div>
				<div class="col-md-4">
					<div class="shop-sidebar row">
						<?php get_sidebar('shop');?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php get_footer(); ?>